  subroutine rdwarren_ice(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=486
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: llset

! Added to original .f90 routine
  integer :: idat
  character(len=80) :: header

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
! Created by /ur/massie/hitran/ascii/rdwarren_ice.f90
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/warren_ice.dat                                 '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
! Output ascii file f.out
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

!
! Data: Real and Imaginary indices of Ice Ih at 266 K

! Reference: Warren SG, Brandt RE. Optical constants of ice from the
! ultraviolet to the microwave: A revised compilation.
! J Geophys Res 2008;113:D14220,doi:10.1029/2007JD009744.

! Email contact person: Stephen G. Warren (sgw@atmos.washington.edu)

! Format: 486 real and imaginary indices (2(1x,e11.4),1(1x,f6.4),1(1x,e10.3))

! cm-1        microns    real    imaginary
! 2.2573e+05  4.4300e-02 0.8228  1.640e-01
! 2.2173e+05  4.5100e-02 0.8250  1.730e-01
! 2.1786e+05  4.5900e-02 0.8255  1.830e-01

  nlines=486

  do i=1,12
   read(idat,fmt=100) header
  end do
  100 format(a80)

  do i=1,nlines
   read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
  end do
 
! Close the input ascii refractive index file
  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=840)
    840 format(/,2x,"rdwarren_ice: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
