  subroutine rdquerry_minerals(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ******
! Read in the data from the ascii file

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=396,ncomp=4
  integer :: id1,istat,noprf,mset,i1,i2
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat,ncomp),rival(ndat,ncomp)
! real :: temps(mtempmax)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/querry_minerals.dat                            '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! The different compositions
!          '1234567890123456'
  files(1)='Clay            '
  files(2)='Illite          '
  files(3)='Kaolin          '
  files(4)='Montrillite     '

! *
! Write out the compounds included in the ascii file
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-4) e.g. mset=2 for Illite ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! ***
! Read in all of the data

!Data: Real and imaginary indices of refraction of materials
!from 2.5 to 50 microns. This listing focuses upon various minerals

!Reference: Marvin R. Querry, Optical Constants of Minerals and
!Other Materials From The Millimeter To The Ultraviolet
!CRDEC-CR-88009, November 1987.

!Contact: Steven Massie (Steven.Massie@lasp.colorado.edu)

!Format: 396 lines 2x,2(1x,f8.2),3(1x,f10.4)
!        396 lines 2x,2(1x,f8.2),3(1x,f10.4)

!     cm-1    microns                    Real
!                        Clay      Illite     Kaolin  Montrillite
!    50.00   200.00     2.1910     2.1880     2.2870     2.1720
!    60.00   166.67     2.1780     2.2170     2.2530     2.1280

! ***
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,15
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcm(i),wavelength(i),(rnval(i,j),j=1,ncomp)
   end do

   do i=1,3
    read(idat,fmt=100) header
   end do
   do i=1,nlines
    read(idat,*) wcm(i),wavelength(i),(rival(i,j),j=1,ncomp)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   rndat(i)=rnval(i,mset)
   ridat(i)=rival(i,mset)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdquerry_minerals: work with mset, files(mset)",/,&
    2x,i3,2x,a16)
    write(iout,fmt=840)
    840 format(2x,"rdquerry_minerals: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines 
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end


