  subroutine rdkhare_titan_tholins(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=60
  integer :: noprf
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character(len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

!       '1234567890123456'
  llset='khare tholins   '

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='exoplanets/khare_tholins.dat                                '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!   stop
  end if

! *****
! Reference: Khare, B. N., C. Sagan, E. T. Arakawa, F. Suits,
! T. A. Callcott, and M. W. Williams
! Optical Constants of Organic Tholins Produced in a Simulated Titanian
! Atmosphere: from Soft X-Ray to Microwave Frequencies
! Icarus, v60, p127-137, 1984
!
! Real and Imaginary Refractive Indices of Titan Tholins
!
! Contact: Steven Massie (Steven.Massie@lasp.colorado.edu)
!
! Format: 90 lines 2x,2(1x,e10.4),2(1x,f10.4)
!
!       cm-1    microns       real    imaginary
!   4.8309e+05 2.0700e-02     0.9200     0.0490
!   3.2051e+05 3.1200e-02     0.8500     0.1400

! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,13
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
!   wavedat(i)=1.0e4/wcmdat(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(2x,"rdkhare_titan_tholins: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdkhare_titan_tholins: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end


