  subroutine rddowning(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! See rdindices.f90
  character(len=16) :: llset

! Used here
  integer :: noprf,ilook
  integer,parameter :: ndat=5000
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil

! ***
! Read in the data from the ascii file
   lset=lstrn
!       '1234567890123456'
   llset='downing_water   '

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/downing_williams_water.dat                     '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
! Data: Real and imaginary indices of refraction for water at 27 C
! between 10 and 5000 cm-1.

! Reference: H. D. Downing and D. Williams, Optical constants of water
! in the infrared, J. Geophys. Res., vol. 80, pgs. 1656-1661, 1975.

! Format: wavenumber (cm-1), wavelength (microns), real and imaginary
! indices of refraction of water at 27 C.
! 420 values   2x,f5.0,2x,f8.3,4x,f5.3,2x,f8.6


! cm-1   microns     real   imaginary
!   10.  1000.000    2.600  1.090200
!   20.   500.000    2.225   .718000
!   30.   333.333    2.150   .527000
!   40.   250.000    2.110   .460000
!21234512123456781234123451212345678 

! Input ascii file 
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

! Read in the data
   do i=1,12
    read(idat,fmt=100) header
   end do
   100 format(a80)

   nlines=420

   do i=1,nlines
    read(idat,fmt=104) wcmdat(i),wavedat(i),rnval(i),rival(i)
    104 format(2x,f5.0,2x,f8.3,4x,f5.3,2x,f8.6)
   end do
  
! Close the ascii input file
   close (idat)

! **************************
! Look at the values read in
   ilook=0
  if (ilook .eq. 1) then 
    write(iout,fmt=400) 
    400 format(/,2x,"i,wcmdat(i),wavedat(i),rnval(i),rival(i)")
   do i=1,nlines
    write(iout,fmt=410) i,wcmdat(i),wavedat(i),rnval(i),rival(i)
    410 format(2x,i4,1p,4(1x,e10.3))
   end do
   stop
  end if

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rddowning: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rddowning: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end
