  subroutine rdbiermann_h2so4(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,&
  nlinesr,wcmr,wavelengthr,rndat,&
  nlinesi,wcmi,wavelengthi,ridat,&
  ndifferent,iwave)

! *****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Case here where number of real and imaginary indices differs
  real :: wcmr(nwavemax),wavelengthr(nwavemax)
  real :: wcmi(nwavemax),wavelengthi(nwavemax)

! Used here
! Notice that the exact number of elements in rnval,rival works
  integer,parameter :: ndatr=8192,ndati=4768,mtempmax=12,nwt=12
  integer :: i,mn,nc
  integer :: ival,jval
  integer :: nlinesr,nlinesi
  integer :: nh2so4(mtempmax)
  real :: a1,a2
  real :: wghth2so4
  real :: vec1(nwt),vec2(nwt)
  integer :: ivec1(nwt),ivec2(nwt)
  real :: diff1,diff2
! Note that the ndat,mtemp is opposite to the ncdump dump
  real :: temps(mtempmax)
  real :: numlinesr(mtempmax),numlinesi(mtempmax)
  real :: wh2so4(mtempmax,nwt)
  real :: wcmr2(ndatr)
  real :: waver2(ndatr)
  real :: rn(ndatr)
  real :: wcmi2(ndati)
  real :: wavei2(ndati)
  real :: ri(ndati)

  real :: wavecmr(ndatr,mtempmax),wavelr(ndatr,mtempmax)
  real :: wavecmi(ndati,mtempmax),waveli(ndati,mtempmax)
  real :: rndatn(ndatr,mtempmax,nwt),ridatn(ndati,mtempmax,nwt)

  character(len=60) :: fil
  character(len=60) :: files(mtempmax)
  character (len=16) :: llset

! ***
   data temps/183.,188.,193.,203.,213.,215.,223.,233.,253.,263.,273.,293./
   data nh2so4/1,2,3,4,5,3,3,7,7,2,10,12/
   ntemps=12

   nlinesr=8192
   nlinesi=4768

! set1
   wh2so4(1,1)=57.0
! set2
   wh2so4(2,1)=57.0
   wh2so4(1,2)=64.0
! set3
   wh2so4(3,1)=30.0
   wh2so4(3,2)=57.0
   wh2so4(3,3)=64.0
! set4
   wh2so4(4,1)=30.0
   wh2so4(4,2)=45.0
   wh2so4(4,3)=57.0
   wh2so4(4,4)=64.0
! set5
   wh2so4(5,1)=30.0
   wh2so4(5,2)=45.0
   wh2so4(5,3)=57.0
   wh2so4(5,4)=60.0
   wh2so4(5,5)=64.0
! set6
   wh2so4(6,1)=70.0
   wh2so4(6,2)=75.0
   wh2so4(6,3)=80.0
! set7
   wh2so4(7,1)=40.0
   wh2so4(7,2)=50.0
   wh2so4(7,3)=60.0
! set8
   wh2so4(8,1)=30.0
   wh2so4(8,2)=40.0
   wh2so4(8,3)=45.0
   wh2so4(8,4)=50.0
   wh2so4(8,5)=57.0
   wh2so4(8,6)=60.0
   wh2so4(8,7)=64.0
! set9
   wh2so4(9,1)=20.0
   wh2so4(9,2)=30.0
   wh2so4(9,3)=40.0
   wh2so4(9,4)=45.0
   wh2so4(9,5)=50.0
   wh2so4(9,6)=57.0
   wh2so4(9,7)=60.0
! set10
   wh2so4(10,1)=0.0
   wh2so4(10,2)=10.0
! set11
   wh2so4(11,1)=0.0
   wh2so4(11,2)=10.0
   wh2so4(11,3)=20.0
   wh2so4(11,4)=30.0
   wh2so4(11,5)=40.0
   wh2so4(11,6)=45.0
   wh2so4(11,7)=50.0
   wh2so4(11,8)=57.0
   wh2so4(11,9)=60.0
   wh2so4(11,10)=64.0
! set12
   wh2so4(12,1)=0.0
   wh2so4(12,2)=10.0
   wh2so4(12,3)=20.0
   wh2so4(12,4)=30.0
   wh2so4(12,5)=40.0
   wh2so4(12,6)=45.0
   wh2so4(12,7)=50.0
   wh2so4(12,8)=57.0
   wh2so4(12,9)=60.0
   wh2so4(12,10)=64.0
   wh2so4(12,11)=75.0
   wh2so4(12,12)=80.0

!          '123456789012345678901234567890123456789012345678901234567890'
  files(1)='biermann_h2so4/h2so4T183.biermann                         '
  files(2)='biermann_h2so4/h2so4T188.biermann                         '
  files(3)='biermann_h2so4/h2so4T193.biermann                         '
  files(4)='biermann_h2so4/h2so4T203.biermann                         '
  files(5)='biermann_h2so4/h2so4T213.biermann                         '
  files(6)='biermann_h2so4/h2so4T215.biermann                         '
  files(7)='biermann_h2so4/h2so4T223.biermann                         '
  files(8)='biermann_h2so4/h2so4T233.biermann                         '
  files(9)='biermann_h2so4/h2so4T253.biermann                         '
  files(10)='biermann_h2so4/h2so4T263.biermann                         '
  files(11)='biermann_h2so4/h2so4T273.biermann                         '
  files(12)='biermann_h2so4/h2so4T293.biermann                         '

! ***
! Read in the data from the ascii file
   lset=lstrn

! The compound string
!       '1234567890123456'
  llset=' Biermann H2SO4 '
  do nf=1,mtempmax

! The input ascii file
  fil=files(nf)
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! Open input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,18
   read(idat,fmt=100) header
  end do
  100 format(a80)

! The number of lines to work with
!   oops, the ascii file reversed wavenumber and wavelength
    nlines=ndatr
    nc=nh2so4(nf)
   do i=1,nlines
!   read(idat,*) wavecmr(i,nf),wavelr(i,nf),(rndatn(i,nf,j),j=1,nc)
    read(idat,*) wavelr(i,nf),wavecmr(i,nf),(rndatn(i,nf,j),j=1,nc)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

    nlines=ndati
   do i=1,nlines
    read(idat,*) wavecmi(i,nf),waveli(i,nf),(ridatn(i,nf,j),j=1,nc)
   end do

  end do

  close (idat)

! ****
! Determine which data to look at
  
! Will specify the wghth2so4 and temp pair
! First, will write out the possibilities

! The wh2so4 and temps values
  if (nopr .eq. 1) then
   write(iout,fmt=320) 
   320 format(/,2x,"rdbiermann_h2so4: i,j,wh2so4(i,j),temps(i)")
   do i=1,mtempmax
   do j=1,nwt
    write(iout,fmt=330) i,j,wh2so4(i,j),temps(i)
    330 format(2x,2(1x,i4),2x,2(1x,f10.4))
   end do
   end do
  end if

! **
! Write out to the screen
   iwrscreen=1
  if (iwrscreen .eq. 1) then
   write(0,fmt=360) 
   360 format(/,2x,"rdbiermann_h2so4: i,j,wh2so4(i,j),temps(i)")
   do i=1,mtempmax
   do j=1,nwt
    ivec1(j)=int(wh2so4(i,j))
    ivec2(j)=int(temps(i))
   end do
    write(0,fmt=365) i,ivec2(1),(ivec1(j),j=1,12)
    365 format(2x,1(1x,i3),1(1x,i4),2x,12(1x,i4))
   end do
  end if

! Specify the temp and wghth2so4 values
  write(0,fmt=165)
  165 format(2x,"Specify temp value (e.g. 215) ")
  read(5,*) temp

  write(0,fmt=160)
  160 format(2x,"Specify wghth2so4 value (e.g. 80) ")
  read(5,*) wghth2so4

  write(0,fmt=170) wghth2so4,temp
  170 format(2x," wghth2so4,temp ",2(1x,f10.4))

    diffmin=1.0e3
    ival=-99
    jval=-99
   do i=1,nwt
   do j=1,mtempmax
    diff1=wh2so4(j,i)-wghth2so4
    diff2=temps(j)-temp
    a1=sqrt((diff1*diff1)+(diff2*diff2))
    if (a1 .lt. diffmin) then 
! weight
     ival=i
! temperature
     jval=j
     diffmin=a1
    end if
   end do
   end do

  if ((ival .lt. 0) .or. (jval .lt. 0)) then
   write(iout,fmt=350) ival,jval
   350 format(/,2x,"rdbiermann_h2so4: ival,jval ",2(1x,i4)," will stop")
   stop
  end if

  if (nopr .eq. 1) then
   write(iout,fmt=170) wghth2so4,temp
   write(iout,fmt=410) ival,jval,wh2so4(jval,ival),temps(jval)
   410 format(/,2x,"rdbiermann_h2so4:ival,jval,wh2so4,temps, ",/,&
   2x,2(1x,i4),2(1x,f10.4))
  end if

! *****
! Specify wcmr2,waver2,rn 
!   read(idat,*) wavecmr(i,nf),wavelr(i,nf),(rndatn(i,nf,j),j=1,nc)
  do i=1,ndatr
   wcmr2(i)=wavecmr(i,jval)
   waver2(i)=wavelr(i,jval)
   rn(i)=rndatn(i,jval,ival)
  end do

! Specify wcmi2,wavei2,ri
!   read(idat,*) wavecmi(i,nf),waveli(i,nf),(ridatn(i,nf,j),j=1,nc)
  do i=1,ndati
   wcmi2(i)=wavecmi(i,jval)
   wavei2(i)=waveli(i,jval)
   ri(i)=ridatn(i,jval,ival)
  end do

! *****
! Put values into the output arrays

  iwrscreen2=0

! The real indices
   nlines=ndatr
  do i=1,nlines
   wcmr(i)=wcmr2(i)
   if (iwrscreen2 .eq. 1) then
    write(0,fmt=7000) i,wcmr2(i),waver2(i),rn(i)
   end if
   7000 format(2x,i4,2x,3(1x,f10.4))
   wavelengthr(i)=waver2(i)
   a1=rn(i)
   if (a1 .le. 0.0) then 
    a1=0.0
   endif
   rndat(i)=a1
  end do

! Specify wcmi2, wavei2, ri

! The imaginary indices
   nlines=ndati
  do i=1,nlines
   wcmi(i)=wcmi2(i)
   wavelengthi(i)=wavei2(i)
   a2=ri(i)
   if (a2 .le. 0.0) then 
    a2=0.0
   endif
   ridat(i)=a2
  end do

! *****
  if (nopr .eq. 1) then

    write(iout,fmt=800) temp,wghth2so4
    800 format(/,2x,"rdbiermann_h2so4: temp,wghth2so4 ",/,2x,2(1x,f10.4),/,&
    2x,"rdbiermann_h2so4: i,wcmr,wavelengthr,rndat")
   do i=1,nlinesr
    write(iout,fmt=850) i,wcmr(i),wavelengthr(i),rndat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do

    write(iout,fmt=870) temp,wghth2so4
    870 format(/,2x,"rdbiermann_h2so4: temp,wghth2so4 ",/,2x,2(1x,f10.4),/,&
    2x,"rdbiermann_h2so4: i,wcmi,wavelengthi,ridat")
   do i=1,nlinesi
    write(iout,fmt=880) i,wcmi(i),wavelengthi(i),ridat(i)
    880 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do

  end if

! ******
  return
  end
