  subroutine rdzeidler_sio2_hightemp(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=1600,ncomp=10
  integer :: noprf,mset
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset
  character (len=16) :: llsets(ncomp)
  character (len=60) :: filei(ncomp)

! **
! The different compositions
!          '1234567890123456'
  files(1)='SiO2 300K ab    '
  files(2)='SiO2 300K c     '
  files(3)='SiO2 551K ab    '
  files(4)='SiO2 551K c     '
  files(5)='SiO2 738K ab    '
  files(6)='SiO2 738K c     '
  files(7)='SiO2 833K ab    '
  files(8)='SiO2 833K c     '
  files(9)='SiO2 928K ab    '
  files(10)='SiO2 928K c     '

! You put all data into one file
!          '123456789012345678901234567890123456789012345678901234567890'
  filei(1)='exoplanets/zeidler_sio2_300k_ab.dat                         '
  filei(2)='exoplanets/zeidler_sio2_300k_c.dat                          '
  filei(3)='exoplanets/zeidler_sio2_551k_ab.dat                         '
  filei(4)='exoplanets/zeidler_sio2_551k_c.dat                          '
  filei(5)='exoplanets/zeidler_sio2_738k_ab.dat                         '
  filei(6)='exoplanets/zeidler_sio2_738k_c.dat                          '
  filei(7)='exoplanets/zeidler_sio2_833k_ab.dat                         '
  filei(8)='exoplanets/zeidler_sio2_833k_c.dat                          '
  filei(9)='exoplanets/zeidler_sio2_928k_ab.dat                         '
  filei(10)='exoplanets/zeidler_sio2_928k_c.dat                         '

!            '1234567890123456'
   llsets(1)='sio2 300K ab    '
   llsets(2)='sio2 300K c     ' 
   llsets(3)='sio2 551K ab    '
   llsets(4)='sio2 551K c     '
   llsets(5)='sio2 738K ab    '
   llsets(6)='sio2 738K c     '
   llsets(7)='sio2 833K ab    '
   llsets(8)='sio2 833K c     '
   llsets(9)='sio2 928K ab    '
   llsets(10)='sio2 928K c     '

! **
! User will select which set to work with
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset 1,2,3,..10 ")

  read(5,*) mset
  mset=int(mset)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
   fil=filei(mset)
   llset=llsets(mset)

   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
! Reference: Zeidler, S., Th. Posch, and H. Mutschke
! Optical constants of refractory oxides at high temperatures
! Mid-infrared properties of corundum, spinel, and alpha-quartz,
! Astronomy and Astrophysics, v553, A81, 2013
!
! Real and Imaginary Refractive Indices of crystalline SiO2 ab at 300 K
!
! Contacts: Simon Zeidler (simon.zeidler@nao.ac.jp)
!           H. Mutschke (harald.mutschke@uni-jena.de)
!
! Format: 1600 lines 2x,2(1x,f8.2),2(1x,f10.4)
!
!      cm-1    microns     real    imaginary
!    1600.00     6.25     1.2930     0.0057
!    1599.00     6.25     1.2925     0.0057

! *****
! Read in the data

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,13
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
    wavedat(i)=1.0e4/wcmdat(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200)
   200 format(/)
   write(iout,fmt=225) nlines,filei(mset) 
   225 format(2x,"rdzeidler_sio2_hightemp: nlines, filei(mset) ",i4,/,&
   2x,a60)
   write(iout,fmt=230) 
   230 format(2x,"rdzeidler_sio2_hightemp: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end
