  subroutine rdquerry_kcl(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=312
  integer :: noprf
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  real :: rerr,imerr
  character(len=60) :: fil
  character(len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

!       '1234567890123456'
  llset='querry kcl      '

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='exoplanets/querry_kcl.dat                                   '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! ******
! Data: Real and imaginary indices of refraction of KCl
!
! Reference: Marvin R. Querry, Optical Constants of Minerals
! and Other Materials From The Millimeter To The Ultraviolet
! CRDEC-CR-88009, November 1987.
!
! Contact: Steven Massie (Steven.Massie@lasp.colorado.edu)
!
! Format: 312 lines 2x,2(1x,f8.2),4(1x,f10.4)
!
!      cm-1    microns     real    imaginary   realerr imaginaryerr
!      60.00   166.67     2.2900     0.1540     0.0140     0.0410
!      80.00   125.00     2.3600     0.1730     0.0150     0.0440
!     100.00   100.00     2.5610     0.1860     0.0160     0.0530

! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,12
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i),rerr,imerr
!   wavedat(i)=1.0e4/wcmdat(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rdquerry_kcl: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdquerry_kcl: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end


