  subroutine rdniedziela_h2so4(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! *****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
! Notice that the exact number of elements in rnval,rival works
  integer,parameter :: ndat=2010,mtemp=8,nwt=6
  integer :: i,i1,i2,i3,i4,j1,j2,k1,k2,mn,nc
  real :: a1,a2
! Note that the ndat,mtemp is opposite to the ncdump dump
  real :: numlines(mtemp)
  real :: wh2so4(mtemp,nwt),wghth2so4,ncomps(mtemp)
  real :: wcmdat(ndat),wavel(ndat)
  real :: rnval(ndat,nwt),rival(ndat,nwt)
  character(len=60) :: fil
  character (len=16) :: llset

  character(len=60) :: files(mtemp)
  real :: temps(mtemp),temp
  data temps/200.,210.,220.,230.,240.,260.,280.,300./
  data ncomps/2,3,6,1,5,6,5,3/

  do i=1,mtemp
  do j=1,nwt
   wh2so4(i,j)=0.0
  end do
  end do

! 200 K
  wh2so4(1,1)=45.0
  wh2so4(1,2)=50.0
! 210 K
  wh2so4(2,1)=32.0
  wh2so4(2,2)=39.0
  wh2so4(2,3)=61.0
! 220 K
  wh2so4(3,1)=38.0
  wh2so4(3,2)=43.0
  wh2so4(3,3)=50.0
  wh2so4(3,4)=55.0
  wh2so4(3,5)=66.0
  wh2so4(3,6)=72.0
! 230 K
  wh2so4(4,1)=75.0
! 240 K
  wh2so4(5,1)=42.0
  wh2so4(5,2)=50.0
  wh2so4(5,3)=59.0
  wh2so4(5,4)=69.0
  wh2so4(5,5)=80.0
! 260 K
  wh2so4(6,1)=42.0
  wh2so4(6,2)=47.0
  wh2so4(6,3)=55.0
  wh2so4(6,4)=72.0
  wh2so4(6,5)=76.0
  wh2so4(6,6)=87.0
! 280 K
  wh2so4(7,1)=50.0
  wh2so4(7,2)=63.0
  wh2so4(7,3)=70.0
  wh2so4(7,4)=76.0
  wh2so4(7,5)=85.0
! 300 K
  wh2so4(8,1)=72.0
  wh2so4(8,2)=75.0
  wh2so4(8,3)=85.0

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! Specify the weight percent h2so4
  write(0,fmt=140)
  140 format(2x,"Specify temperature (200, 210, 220, 230, 240, 260, 280, 300) ")
  read(5,*) temp

  write(0,fmt=165) temp
  165 format(2x," will use temp ",f10.4)

   diffmin=1.0e6
  do i=1,mtemp
   diff=abs(temp-temps(i))
   if (diff .lt. diffmin) then 
    k1=i
    diffmin=diff
   end if 
   numlines(i)=2010
  end do

!          '123456789012345678901234567890123456789012345678901234567890'
  files(1)='niedziela_h2so4/h2so4T200.niedziela                         '
  files(2)='niedziela_h2so4/h2so4T210.niedziela                         '
  files(3)='niedziela_h2so4/h2so4T220.niedziela                         '
  files(4)='niedziela_h2so4/h2so4T230.niedziela                         '
  files(5)='niedziela_h2so4/h2so4T240.niedziela                         '
  files(6)='niedziela_h2so4/h2so4T260.niedziela                         '
  files(7)='niedziela_h2so4/h2so4T280.niedziela                         '
  files(8)='niedziela_h2so4/h2so4T300.niedziela                         '

! The compound string
!       '1234567890123456'
  llset=' Niedziela H2SO4'

! ***
! The input ascii file
  fil=files(k1)
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! *****
! Find the indices for the interpolation

!
!  Data: Real and imaginary indices of liquid H2SO4/H2O
!  at 260 K from 825 to 4700 cm-1.

!  Reference: Niedziela, R. F., M. L. Norman, C. L. deForest,
!  R. E. Miller, and D. R. Worsnop, A Temperature and
!  Composition-Dependent Study of H2SO4 Aerosol Optical
!  Constants Using Fourier Transform and Tunable Diode
!  Laser Infrared Spectroscopy, J. Phys. Chem. A,
!  vol. 103, pgs. 8030-8040, 1999.
!
!  Email contact person:  R. E. Miller (remiller@unc.edu)
!
!  Format: 2010 real indices (2x,f7.2,2x,f10.4,6(1x,f5.3))
!          2010 imaginary indices (2x,f7.2,2x,f10.4,6(1x,e10.3))
!
!   cm-1       microns  real
!                      42%   47%   55%   72%   76%   87%
!   825.59     12.1126 1.522 1.678 1.708 1.810 1.849 2.005
!   827.51     12.0844 1.526 1.680 1.710 1.814 1.853 2.012

! Open input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,18
   read(idat,fmt=100) header
  end do
  100 format(a80)

! The number of lines to work with
   nlines=numlines(k1)

   nc=ncomps(k1)
   do i=1,nlines
    read(idat,*) wcmdat(i),wavel(i),(rnval(i,j),j=1,nc)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavel(i),(rival(i,j),j=1,nc)
   end do

  close (idat)

  write(0,fmt=596) temp,k1,temps(k1),nlines
  596 format(2x,"temp,k1,temps(k1),nlines ",2x,f10.4,2x,i4,2x,f10.4,2x,i4)

! ***
! The number of h2so4 values to look at
    nc=ncomps(k1)
   write(0,fmt=605) nc
   605 format(2x,"nc, number of h2so4 values to look at ",i3)

! ***
! The weight percent h2so4
   j1=-99

   write(0,fmt=899) 
   899 format(2x,"Here are the wh2so4 values to choose from")
  do i=1,nc
   write(0,fmt=900) wh2so4(k1,i)
   900 format(2x,f10.4)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify the wghth2so4 value ")
  read(5,*) wghth2so4

  write(0,fmt=170) wghth2so4
  170 format(2x," wghth2so4 ",f10.4)

  if (wghth2so4 .lt. wh2so4(k1,1)) then
   j1=1
   go to 600 
  end if
  if (wghth2so4 .ge. wh2so4(k1,nc)) then
   j1=nc
   go to 600 
  end if
  do i=1,nc-1
    i3=i
    i4=i+1
    a1=wh2so4(k1,i3)
    a2=wh2so4(k1,i4)
   if ((wghth2so4 .ge. a1) .and. (wghth2so4 .lt. a2)) then
    j1=i
    go to 600 
   end if
  end do
  600 mn=0

! Check
  if (j1 .le. 0) then 
   write(0,fmt=610)
   610 format(2x,"j1 le 0 for h2so4, will stop")
   stop
  end if

  write(0,fmt=611) wghth2so4,j1,wh2so4(k1,j1),nlines
  611 format(2x,"wghth2so4,j1,wh2so4(k1,j1),nlines ",/,&
  2x,f10.4,2x,i4,2x,f10.4,2x,i4)

! *******
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavel(i)
   a1=rnval(i,j1)
   a2=rival(i,j1)
   if (a1 .le. 0.0) then 
    a1=0.0
   endif
   if (a2 .le. 0.0) then 
    a2=0.0
   endif
   rndat(i)=a1
   ridat(i)=a2
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) temp,wghth2so4,k1,temps(k1),j1,wh2so4(k1,j1)
    800 format(/,2x,"rdniedziela: temp,wghth2so4 ",/,2x,2(1x,f10.4),/,&
    2x,"rdniedziela: k1,temps(k1),j1,wh2so4(k1,j1) ",/,&
    2x,2(1x,i4,2x,f10.4),/,&
    2x,"rdniedziela: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
