  subroutine rdbegemann_al2o3(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=64,ncomp=2
  integer :: noprf,mset
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset

! **
! The different compositions
!          '1234567890123456'
  files(1)='Al2O3 Porous    '
  files(2)='Al2O3 Compact   '

! **
! User will select which set to work with
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset  1 or 2 ")

  read(5,*) mset
  mset=int(mset)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
  if (mset .eq. 1) then
!      '123456789012345678901234567890123456789012345678901234567890'
   fil='exoplanets/begemann_al2o3_porous.dat                        '
!       '1234567890123456'
   llset='al2o3 porous   '
  end if
  if (mset .eq. 2) then
!      '123456789012345678901234567890123456789012345678901234567890'
   fil='exoplanets/begemann_al2o3_compact.dat                       '
!       '1234567890123456'
   llset='al2o3 compact  '
   nskip=13
  end if

   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
! Reference: Begemann, B., J. Dorschner, Th. Henning, H. Mutschke
! J. Gurtler, C. Kompe, and R. Nass
! Aluminum oxide and the opacity of oxygen-rich circumstellar dust in
! the 12-17 micron range
! Astrophysical Journal, v476, p199-208, 1997
!
! Real and Imaginary Refractive Indices of compact Al2O3
!
! Contact: H. Mutschke (harald.mutschke@uni-jena.de)
!
! Format: 64 lines 2x,2(1x,f9.2),2(1x,f10.4)
!
!       cm-1    microns     real    imaginary
!     1282.05      7.80     1.3430     0.0780
!     1250.00      8.00     1.3230     0.0860

! Read in the data

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,13
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rdbegmann_al2o3: nlines, fil ",i4,/,&
   2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdbegemann_al2o3: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end


