function readerrsum, datastr, file, quiet=quiet

; Read Error Summary File --------------------------------------------------------------------

  ;---------------------
  ; Build data structure
  ;---------------------
  datastr = {                    $
              tot_rand    : 0.D0,$    ; Total random uncertainty [molecules cm^-2]
              tot_sys     : 0.D0 $    ; Total systematic uncertainty [molecules cm^-2]
            }  

  if( not keyword_set( quiet ))then print,'ReadErrSum opening file : ', file

	;------------------------
	; Open Error Summary file
	;------------------------
	openr, lun, file, /get_lun, error=ioerr
	if( ioerr ne 0 ) then begin
		printf, -2, !err_string
		;free_lun, lun, /force
		return, 1
	endif
	
	;-----------------------------
	; Read data into dat structure
	;-----------------------------
  buf = ''
  while( not eof(lun) )do begin
    readf, lun, buf
    
    if strcmp(buf, 'Total random uncertainty      ', 30, /fold_case) then begin
      subs = strsplit( buf,' ',/extract, count=nitms )
      datastr.tot_rand = subs[4] + 0.0D0
    endif
    
    if strcmp(buf, 'Total systematic uncertainty   ', 31, /fold_case) then begin
      subs = strsplit( buf,' ',/extract, count=nitms )
      datastr.tot_rand = subs[4] + 0.0D0
    endif
    
  endwhile
	
	;------------------
	; Free fid and exit
	;------------------
  print, 'readerrsum : ', file, ' file done'
	free_lun, lun
	return, 0

end