pro  print2file, file=file, maxrms=maxrms, years=years

if( not keyword_set( maxrms )) then begin
   maxrms = 1.0
   print, '  main : setting maxrms limit to : ', maxrms
endif

restore, file

if( not keyword_set( years )) then begin
   years = min(ds.year) + indgen( max(ds.year)-min(ds.year)+1 )
   print, '  main : setting year range to : ', years
endif


d1  = ds
print, 'Number of retrievals in save file : ',  n_elements(ds)
dx1 = where( d1.rms LT maxrms, nobs )
print, 'Number of retrievals in max rms criteria : ',  nobs
ds  = d1[dx1]

pos = strpos( file, '.' )
outfile =  strmid( file, 0, pos ) + '.txt'

openw,lun,outfile,/get_lun
printf, lun, 'File_Name      YYYY-MM-DD     HH:MM:SS        Total_Column     DOFS      RMS       SZA'

for i = 0, n_elements(years)-1 do begin

  inds = where( ds.year eq years[i], count )
   print, count
  fname = ds[inds].spectraname
  t_col = ds[inds].rettc
  dofs  = ds[inds].dofs
  sza   = ds[inds].sza
  rms   = ds[inds].rms
  year  = ds[inds].year
  mnth  = ds[inds].month
  day   = ds[inds].day
  hhfr  = ds[inds].hrs
  hh    = floor(hhfr)
  mmfr  = (hhfr-hh)*60.0
  mm    = floor(mmfr)
  ss    = floor((mmfr-mm)*60.0)

  nobs = n_elements(year)


  strformat = '(A25,5x,i4,"-",i02,"-",i02,5x,i02,":",i02,":",i02,5x,e15.6,5x,f5.3,5x,f5.3,5x,f7.3)'
  for j=0,nobs-1 do begin
    printf, lun, fname[j],year[j],mnth[j],day[j],strtrim(hh[j],2),strtrim(mm[j]),strtrim(ss[j]),t_col[j],dofs[j],rms[j],sza[j], format=strformat
  endfor

endfor


  free_lun, lun


end
