pro pltpbp4, ps=ps, thicklines=thicklines

; feb 2012
; from oex...plot only pbpfile

; idl script to plot sfit2 output
; originally scripted in matlab now converted to idl
;adapted 18/3/2010 to add in total column amount from retrieval rb

	print, ' usage : oex, site="mlo | tab | acf", /ps, /thick, ftype= "b" | "l"'

	if( not keyword_set( thicklines )) then begin
		print, '  main : keyword thicklines  not set.'
		print, '  main : setting default thicklines=0 -> use thin lines.'
		thicklines = 0  		 ;  0 means thin lines, 1 means thick lines
	endif

	if( not keyword_set( ftype )) then begin
		print, '  main : keyword ftype not set.'
		print, '  main : setting default ftype=b -> use big endian for mac.'
		ftype = 'b'
	endif

	if( not keyword_set( ps )) then begin
		print, '  main : keyword ps not set.'
		print, '  main : setting default ps=0 -> do not create ps output.'
		ps = 0
	endif

	; ppos running position & id of last plot on screen
	ppos = intarr(3)
	ppos = [ 10, 380, 0 ]			; work - double screens

	psiz = intarr(2)
	psiz = [ 600, 465 ]
	psiz = [ 900, 700 ]

	forward_function plotpbp, exponent

	encap = 0
	plottop = 120

; set up file names from lapack version sfit2 run
	setfilenames, pbpfile, stfile, akfile, kfile, smfile, ssfile, aefile, ptfile, shfile, prfile

; read in pbpfile
	rc = 0
	rc = readpbp4( pbp, pbpfile )

	if( rc ne 0 ) then begin
		printf, -2,'could not read pbp file: ', pbpfile
		return
		stop
	endif

	; 0 = x, 1 = ps
	for tops = 0 , ps do begin

		thick = 1.0
		if tops then begin ;1
			set_plot, 'ps'
			psfile = 'pltpbp.ps'
			print, 'saving ps file to : ', psfile
			device, /color, /landscape, $
			filename = psfile, encapsulated = encap, bits=8
			; full page ps

	      if thicklines then thick=3.5
			!p.charsize = 1
			!p.charthick = 4.0
			!x.thick = thick
			!y.thick = thick
			stickthick = 8
			charsize = 2.
			lthick = thick
			fillcolor = 170
			tek = 0 ; black

		endif else begin
			set_plot,'x'
			device, decompose = 0 ; allow for terminals with > 256 color

			if thicklines then thick=2.0
			!p.charsize = 1
			!p.charthick = 1
			!p.thick = thick
			!x.thick = thick
			!y.thick = thick
			stickthick = 1
			charsize = 1.5
			lthick = thick
			fillcolor = 0
			tek = 1 ; white

		endelse

		; plot spectra
		rc = plotpbp( pbp, tops, ppos, psiz, tek, lthick, summary, nsum, 'zzz' )

		; plot  profiles
		;c = plotprfs( stat, tops, ppos, psiz, a.vmrscl, a.vmrunits, $
		;		tek, lthick, plottop, vmrng )

		; plot bnr file
		;rc = plotbnr( pbp, tops, ppos, psiz, stickthick, plottop, ftype )

		if( tops ) then device, /close_file

	endfor ; tops

end


; plot spectra --------------------------------------------------------------------

function plotpbp, pbp, tops, ppos, psiz, tek, lthick, summary, nsum, smol

	!p.multi = 2

	dfpos = fltarr(4)
	sppos = fltarr(4)
	ftpos = fltarr(5); changed from 3 rb

	nfit = pbp[0].nfit

	tek_color
	for kk = 0, nfit-1 do begin

		; set up windows
		if tops then begin

			dfpos = [0.12, 0.80, 0.93, 0.97]	; ps
			sppos = [0.12, 0.20, 0.93, 0.74]
;			ftpos = [ .00, .04, 0.08 ];rb
			ftpos = [0.00, .02, .04, .06, 0.08]
			hdpos = .76
			if( kk ne 0 ) then erase

		endif else begin

			dfpos[*] = [0.15, 0.78, 0.95, 0.90]	; x
			sppos[*] = [0.15, 0.20, 0.95, 0.72]
			;ftpos[*] = [ .02, .05, 0.08 ]; rb
			ftpos[*] = [ .00, .02, 0.04, 0.06, 0.08]
			hdpos = 0.74
			ppos = ppos + [ 20, -20, 1 ]

			window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
				title = string( 'plot ', ppos[2], $
				format = '(a,i02)') + ' : spectral fit : ' + string( kk+1, nfit, format='(i02,"/",i02)' ), $
				xpos = ppos[0], ypos = ppos[1]

		endelse

		npt1 = pbp[kk].npt -1

		; set diff range
		mx = max( pbp[kk].difspc[0:npt1], min=mn )
		if( abs(mn) gt abs(mx) ) then mx = mn
		!y.range = [ -abs(mx), abs(mx) ]

		titl = pbp.tag + '!C' + pbp.title
		; plot difference on top
		plot, pbp[kk].wnu[0:npt1], pbp[kk].difspc[0:npt1],  	$
			position = dfpos, yticks = 4, title = titl,			$
			/nodata, ytitle='difference', charsize = 1.1, 		$
			xtickname = replicate(' ',30), xticklen = 0.08 ;	$
			;xtitle = 'wavenumber [cm!e-1!n]'

		oplot, !x.crange, [0.0,0.0], color = tek, thick = lthick/2
		oplot, pbp[kk].wnu[0:npt1], pbp[kk].difspc[0:npt1], color = 4, $
		thick = lthick

		; calculate ymin and ymax for transmission plot
		omx = max( pbp[kk].obsspc[0:npt1], min=omn )
		cmx = max( pbp[kk].synspc[0:npt1], min=cmn )

		if( omx gt cmx ) then begin
			mx = omx
		endif else begin
			mx = cmx
		endelse

		if( omn lt cmn ) then begin
			mn = omn
		endif else begin
			mn = cmn
		endelse

		; set range and ticks on ordinate
		ymn = 5
		if( mn gt 0.8 ) then mn = 0.8
		if( mn eq 0.8 ) then ymn = 2
		if( mn lt 0.8 and mn ge .4) then mn = 0.4
		if( mn eq 0.4 ) then ymn = 3
		;if( mn lt 0.4 and mn ge .2) then mn = 0.2
		if( mn eq 0.2 ) then ymn = 4
		if( mn lt 0.2 ) then mn = 0.0
		if( mn eq 0.0 ) then ymn = 5
		if( mx gt 1.0 ) then mx = 1.0

		!y.range=[mn,mx]
		;print, !y.range

		; plot spectra
		plot, pbp[kk].wnu[0:npt1], pbp[kk].obsspc[0:npt1],    $
			position = sppos, yticks = 4,						$
			/nodata, ytitle='transmission', charsize = 1.4, 	$
			xticklen = 0.06, ystyle = 1, yminor = ymn,			$
			xtitle = 'wavenumber [cm!e-1!n]'

		if( !y.crange[0] lt 0.0 ) then oplot, !x.crange, [0.0,0.0], color = tek

		oplot, pbp[kk].wnu[0:npt1], pbp[kk].obsspc[0:npt1], $
			color = 3, thick = lthick, /noclip

		oplot, pbp[kk].wnu[0:npt1], pbp[kk].synspc[0:npt1], $
			color = 2, thick = lthick, /noclip

		;legend = string( 'observed', 'fitted', 'difference', format='(3a14)' )
		;print, legend
		xyouts, 0.12, hdpos, 'observed', /normal, color = 3, charsize=1.7
		xyouts, 0.30, hdpos, 'calculated', /normal, color = 2, charsize=1.7
		xyouts, 0.50, hdpos, 'difference', /normal, color = 4, charsize=1.7

cz = 1.0
;	   xyouts, 0.5, ftpos[0], summary[3], /normal, charsize=cz, alignment = 0.5
;      xyouts, 0.5, ftpos[1], summary[2], /normal, charsize=cz, alignment = 0.5
;  	   xyouts, 0.5, ftpos[2], summary[4], /normal, charsize=cz, alignment = 0.5
;		xyouts, 0.5, ftpos[3], summary[1], /normal, charsize=cz, alignment = 0.5
;		xyouts, 0.5, ftpos[4], summary[nsum-1], /normal, charsize=cz, alignment = 0.5
		;xyouts, 0.5, ftpos[2], summary[nsum-1], /normal, charsize=1.2, alignment = 0.5

	endfor

	return, 0

end


; set file names  --------------------------------------------------------------------

pro setfilenames, pbfile, stfile, akfile, kfile, smfile, ssfile, aefile, ptfile, shfile, prfile

; spectra, fit & difference 	: pbpfile
pbfile = 'pbpfile';

; profile & apriori				: statevec
stfile = 'statevec';

; averaging kernels				: ak.out
akfile = 'ak.out'

; jacobian						: k.out
kfile  = 'k.out';

; smoothing error				: ss.out
ssfile = 'ss.out';

; measurement error				: sm.out
smfile = 'sm.out';

; eiganvectors					: aeigen.out
aefile = 'aeigen.out';

; pressure-temperature 			; fasc.pt
ptfile = 'fasc.pt'

; comments						; summary.st
shfile = 'summary.st';

; profiles - nostly need z boundries						; summary.st
prfile = 'prfs.out';

;print, pbfile, stfile, akfile, kfile, smfile, ssfile, aefile, ptfile, shfile

msfile = 'fasc.ms'
mxfile = 'fasc.mx'
cifile = 'cinput';
asfile = 'a-s.out';

end




	;stop
		;	color table 5				tek_color
		; color on screen,   on ps 		on screen		on ps
		;  	0		black 				0				1
		;	50		blue				4				4
		;  	80		purple				6				6
		;  	100		red					2				2
		;  	150 	yellow
		;	200		orange
		;	230		pale yellow
		;	180		yellow green
		;  	255		white				1				0
		;			green				3				3
		;  			teal				5				5


function exponent, axis, index, number

	; a special case.
	if number eq 0 then return, '0'

	; assuming multiples of 10 with format.
	ex = string(number, format='(e8.0)')
	pt = strpos(ex, '.')

	first = strmid(ex, 0, pt)
	sign = strmid(ex, pt+2, 1)
	thisexponent = strmid(ex, pt+3)

	;print, number, ex, first
	;help, first, sign

	; shave off leading zero in exponent
	while strmid(thisexponent, 0, 1) eq '0' do thisexponent = strmid(thisexponent, 1)

	; fix for sign and missing zero problem.
	if (long(thisexponent) eq 0) then begin
		sign = ''
		thisexponent = '0'
	endif

	; make the exponent a superscript.
	if sign eq '-' then begin

	if( strtrim(first,2) eq '1' ) then begin
		return, '10!u' + sign + thisexponent + '!n'
	endif else begin
		return, first + 'x10!u' + sign + thisexponent + '!n'
	endelse

	endif else begin
	if strtrim(first,2) eq '1' then begin
		if strtrim(thisexponent,2) eq '0' then return, '1'
		if strtrim(thisexponent,2) eq '1' then return, '10'
		return, '10!u' + thisexponent + '!n'
		endif else begin
			return, first + 'x10!u' + thisexponent + '!n'
		endelse
	endelse


	end