pro lft, kern=kern, v11=v11

; plot up linefit output
; run in an lft11 output directory

   nspec = 16
   fbase = 'specreXX.dat'

   for tops = 0, 1 do begin

		rc = mkplot(toPS, ppos, psiz, 'lft.ps', /first, title='first plot')

; 1 ils phase and modulation

      if( keyword_set(v11) )then begin
         file = 'ilsparms.dat'
         buf = ''
         err = 0
         mdl = fltarr(3,20)
         openr, lun, file, /get_lun, error=err
         if( err ne 0 )then goto, sk1
            readf, lun, buf
            readf, lun, mdl
         free_lun, lun
         subs = strsplit( buf, /extract)
      endif else begin
         file = 'ilsparms.dat'
         err = 0
         ils = fltarr(2,20)
         openr, lun, file, /get_lun, error=err
         if( err ne 0 )then goto, sk1
            readf, lun, ils
         free_lun, lun

         file = 'modulat.dat'
         buf = ''
         err = 0
         mdl = fltarr(3,20)
         openr, lun, file, /get_lun, error=err
         if( err ne 0 )then goto, sk1
            readf, lun, buf
            readf, lun, mdl
         free_lun, lun
         subs = strsplit( buf, /extract)
      endelse

		rc = mkplot(toPS, ppos, psiz, title='ILS')

      plot, mdl[0,*], mdl[1,*], ystyle=8, ytitle=subs[1], xtitle=subs[0], /nodata, title=file, yrange=[0.95,1.05], xstyle=9
      oplot, mdl(0,*), mdl(1,*), color=2
      ;oplot, mdl(0,*), ils(0,*), color=3

      mdl[2,*] = mdl[2,*]*1.e3
      mx = max(mdl(2,*), min=mn)
      axis, yaxis=1, yrange =[mn,mx], ytitle = subs[2] + ' [mr]', /save
      oplot, mdl(0,*), mdl(2,*), color=4
      ;oplot, mdl(0,*), ils(1,*)*1.e3, color=5

; 1 Kernel plot

      if( keyword_set (kern) )then begin
         sk1:
         ;file = 'actparms.dat'
         file = 'kernel.dat'
         nrows = 0
         buf = ''
         err = 0
         openr, lun, file, /get_lun, error=err
         if( err ne 0 )then goto, sk2
            while( not eof(lun) ) do begin
              readf, lun, buf
              nrows++
            endwhile
         free_lun, lun
         subs = strsplit( buf, /extract, count=ncols)

         krn = dblarr(ncols,nrows)
         openr, lun, file, /get_lun
            readf, lun, krn
         free_lun, lun

   ;for j=0, 10 do begin
   ;   offs=j+58

         offs=32
         rc = mkplot(toPS, ppos, psiz, title='Kernels')

         k = krn[offs:offs+20,offs:offs+20]
         plot, mdl[0,*], k[0,*], ystyle=9, ytitle='Kernel', xtitle='Optical Path [cm]', /nodata, title=file, yrange=[-0.1, 1.1], xrange=[0,250], xstyle=9

         for i=0, 19 do begin
            oplot, mdl[0,*], k[i,*], color=i+1
         endfor

      ;endfor
      ;stop
   endif

; 2 complex interferogram

      sk2:
      file = 'cifg.dat'
      buf = ''
      err = 0
      ils = fltarr(3,20)
      openr, lun, file, /get_lun, error=err
         if( err ne 0 )then goto, sk3
         readf, lun, buf
         readf, lun, ils
      free_lun, lun
      subs = strsplit( buf, /extract)

		rc = mkplot(toPS, ppos, psiz, title='CMPLX IFGM')

      plot, ils(0,*), ils(1,*), ystyle=8, ytitle=subs[1], xtitle=subs[0], $
      /nodata, title=file, xstyle=9
      oplot, ils(0,*), ils(1,*), color = 2

      mx = max(ils(2,*), min=mn)
      axis, yaxis=1, yrange =[mn,mx], ytitle = subs[2],/save
      ;print, ils(2,*)
      oplot, ils(0,*), ils(2,*), color = 4


; 3 plot Instrument response function

      sk3:
      file = 'ilsre.dat'
      n = 0
      buf = ''
      err = 0
      openr, lun, file, /get_lun, error=err
      if( err ne 0 )then goto, sk4
         while( not eof(lun) ) do begin
           readf, lun, buf
           n++
         endwhile
      free_lun, lun
      ils = fltarr(2,n)
      openr, lun, file, /get_lun
         readf, lun, ils
      free_lun, lun

		rc = mkplot(toPS, ppos, psiz, title='Instrument Response')

      ;print, ils(0,*)
      plot, ils(0,*), ils(1,*), ytitle='Response', xtitle='OPD [cm]', $
      /nodata, title=file
      oplot, ils(0,*), ils(1,*), color = 2

; zoom in
		rc = mkplot(toPS, ppos, psiz, title='Instrument Response 2')

      ;print, ils(0,*)
      plot, ils(0,*), ils(1,*), ytitle='Response', xtitle='OPD [cm]', $
      /nodata, title=file, xrange = [-0.050, 0.050], yrange=[-50,50], noclip=0
      oplot, ils(0,*), ils(1,*), color = 2, noclip=0

      ; find FWHM of center peak
      ; find zero
      nzero = where( ils[0,*] EQ 0 )
      nz = nzero[0]
      ;print, nzero, ils[0:1,nz:nz+20]
      ;help, ils

      ; find all points x > x(nz) until y is a minimum - this can vary a lot with zero filling
      nzi = nz + 1
      while( ils[1,nzi] GT ils[1,nzi+1] ) do begin
         nzi = nzi + 1
      endwhile
      ;print, nzi, ils[0:1,nzi]

      ; find midpoint of y
      mx = max(ils[1,*],min=mn)
      val = (mx+mn)/2.

      ; consider it a straight line and determine the x value at the mid height
      print, 'Min,  Max, half max: ', mn, mx, val
      ;mxb = linfit( ils[1,nz:nzi], ils[0,nz:nzi] )
      mxb = poly_fit( ils[1,nz:nzi], ils[0,nz:nzi], 2 )

      y = mxb[2]*val*val + mxb[1]*val + mxb[0]
      fwhm = abs(2.*y)

      print, fwhm
      xyouts, -0.05, 40, 'FWHM = ' + string( fwhm, format='(f7.4)' )

; 3 plot a spectrum

      ;ppos = [ 500, 400, 0 ]
      sk4:
      for j=1, nspec do begin

         file = fbase
         id = string( j, format='(i02)')
         strput, file, id, 6
         ;print, file
         bun = ''
         n = 0
         err = 0
         openr, lun, file, /get_lun, error=err
            if( err ne 0 )then goto, sk5
            while( not eof(lun) ) do begin
              readf, lun, buf
              n++
            endwhile
         free_lun, lun
         if( keyword_set(v11) )then begin
            spec = fltarr(4,n)
         endif else begin
            spec = fltarr(5,n)
         endelse
         openr, lun, file, /get_lun
            readf, lun, spec
         free_lun, lun

         rc = mkplot(toPS, ppos, psiz, title='Spectrum Fit', /pmulti)

         print, 'plot spec : ', j
         mx = max(spec[1,*], min=mn)
         yrng = [0.,1.05]
         if( mn GT 0.5 ) then yrng = [0.5,1.05]
         plot, spec[0,*], spec[1,*], /nodata, yrange = yrng, $
            xtitle='Wavenumber [cm]-1', ytitle='Transmission', $
            xtickformat='(f86.1)', ystyle=8, xstyle=9
         oplot, spec[0,*], spec[1,*], color = 2
         oplot, spec[0,*], spec[2,*], color = 3

         xrng = (!x.crange[1] - !x.crange[0])
         yrng = (!y.crange[1] - !y.crange[0])
         xmin = !x.crange[0]
         ymin = !y.crange[0]

         xyouts, xmin+0.05*xrng, ymin+0.05*yrng, 'Measured', color=2
         xyouts, xmin+0.05*xrng, ymin+0.15*yrng, 'Calculated', color=3

         dif = spec[3,*] * 100.
         mx = max(dif, min=mn)
         mm = ( mx - mn ) / 2.
         axis, yaxis=1, yrange =[-mm*10.,mx], ytitle='Difference %', /save, ystyle = 1
         oplot, spec[0,*], dif, color=4

         sk5:

      endfor

   if( tops )then device, /close
   endfor

return
end

function mkplot, tops, ppos, psiz, psfile, title=title, first=first, pmulti=pmulti

	encap = 0
   if not keyword_set( pmulti ) then pmulti=1

   if( keyword_set(first) )then begin

      ; ppos running position & id of last plot on screen
      ppos = INTARR(3)
      ppos = [ 1600, 1000, 0 ]			; work - double screens
      ppos = [ 400, 400, 0 ]

      ; plot size on screen, PS is a page
      psiz = INTARR(2)
      psiz = [ 600, 465 ]
      plottop = 80.0

      if( tops )then begin ;1
         set_plot, 'ps'
         if( not keyword_set(psfile)  ) then psfile='mkplot.ps'
         print, '  Saving ps file to : ', psfile
         device, /color, /landscape, $
         filename = psfile, encapsulated = 0, bits=8
      endif else begin  ;0
         set_plot,'x'
         device, decompose = 0  ; allow for terminals with > 256 color
      endelse
      return, 0
   endif

	if( tops )then begin
		erase
		tek_color
		if( pmulti eq 2 )then begin
		   !p.multi= [ 0,2,0,0,0]
	      !p.position = 0
	   endif else begin
	      !p.multi= 0
		   !p.position  = [0.1,0.18,0.8,0.82 ]
		endelse
		!p.charsize  = 1.5
		!p.charthick = 6.0
		!p.thick = 6.0
		!x.thick = 6.0
		!y.thick = 6.0

		charsize = 1.5
		xcharsz = 1.3
		ycharsz = 1.3
		lthick = 2
      fillcolor = 170
      tek = 0 ; black
	endif else begin
		ppos = ppos +  [ 20, -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title = string( 'plot ', ppos[2], format='(a,i02)') + '  ' +title ,  $
			xpos = ppos[0], ypos = ppos[1]
		device, decompose = 0
		tek_color
		if( pmulti eq 2 )then begin
		   !p.multi= [ 0,2,0,0,0]
	      !p.position = 0
	   endif else begin
	      !p.multi= 0
		   !p.position = [0.15,0.15,0.82,0.75 ]
		endelse
		!p.charsize = 1.4
		!p.charthick = 1
		!p.thick = 1.
		!x.thick = 1.
		!y.thick = 1.

		charsize = 1.0
		xcharsz = 1.
		ycharsz = 1.
		lthick = 1.
      fillcolor = 0
      tek = 1 ; white
	endelse

return, 0
end
