PRO bnrplt, file=file, screen=screen, orient=orient, encap=encap, ftype=ftype, pt=pt

; Modifications

;	23 Oct 2001
;	- put together mainluy from sfitplt.pro
;
;

;print, N_PARAMS()

    PRINT, ''
    ptt = 1
    IF NOT KEYWORD_SET( pt ) THEN BEGIN
        ptt = 0
    ENDIF

    IF NOT KEYWORD_SET( file ) THEN BEGIN
        Usage
        file=''
        read, file, prompt='Enter bnr file name:  '
    ENDIF

    IF NOT KEYWORD_SET( screen ) THEN BEGIN
        PRINT, '  Setting default: X-window to low resolution.'
        screen = 'H'
    ENDIF ELSE BEGIN
        screen = STRUPCASE( STRMID( screen, 0, 1 ))
        IF ( screen NE 'L' ) AND ( screen NE 'H' ) THEN Usage
    ENDELSE

    IF NOT KEYWORD_SET( orient ) THEN BEGIN
        PRINT, '  Setting default: postscript orientation to portrait.'
        orient = 'L'
    ENDIF ELSE BEGIN
        orient = STRUPCASE( STRMID( orient, 0, 1 ))
        IF ( orient NE 'P' ) AND ( orient NE 'L' ) THEN Usage
    ENDELSE

    IF NOT KEYWORD_SET( encap ) THEN BEGIN
        PRINT, '  Setting default: not encapsulated postscript.'
        encap = 0
    ENDIF ELSE BEGIN
        IF ( encap LT 0 ) OR ( encap GT 1 ) THEN Usage
    ENDELSE

    IF NOT KEYWORD_SET( ftype ) THEN BEGIN
        PRINT, '  Setting default: little endian FORTRAN file type.'
        ftype = 'L'
    ENDIF ELSE BEGIN
        ftype = STRUPCASE( STRMID( ftype, 0, 1 ))
        IF ( ftype NE 'B' ) AND ( ftype NE 'L' ) AND ( ftype NE 'C' ) THEN Usage
    ENDELSE

;    print, 'Source /sj/jamesw/tools/idl/sfitplt.pro'
;    print, 'binput file: ', file
;    print, 'screen: ', screen
;    print, 'orientation: ', orient
;    print, 'encapsulation: ', encap
;    print, 'file type: ', ftype


; Set up some variables



; Set up name and data string

    buffer= string( replicate( 32b, 80 ))
    SPAWN,'date +"%T %Z %b %e %Y"',date
    date='bnrplt.pro v.01 ' + date

; Create postscript file name

    pstfil = STRTRIM( file, 2 ) + '.ps'


REREADFILE:

    IF ( ftype EQ 'B' ) THEN 			$
        OPENR, sftlun, file, /get_lun ,/F77_UNFORMATTED, /SWAP_ENDIAN	$
    ELSE IF ( ftype EQ 'C' ) THEN 		$
        OPENR, sftlun, file, /get_lun 		$
    ELSE					$
        OPENR, sftlun, file, /get_lun ,/F77_UNFORMATTED

    header=string(replicate(32b,80))
    READU, sftlun, header
    header = STRTRIM( header, 2 )
    PRINT, 'File header:'
    PRINT, header
    PRINT, ''

    wlo=0D & whi=0D & spa=0D & npp=0L

    READU,sftlun,wlo,whi,spa,npp
    print, wlo, whi, spa, npp

    arr=FLTARR(npp)
    READU, sftlun, arr
    FREE_LUN, sftlun

; for old bnr files
    ;for j=0,npp-1 do begin
    ;   readu,sftlun,s
    ;   arr(j)=s
    ;endfor

xar=float(wlo+spa*FINDGEN(npp))

;print,header
;print,wlo,whi,spa,npp,format='(3f12.5,i10)'
;print,arr,format='(8f10.3)'
;print,xar,format='(8f10.3)'


; Plotting fit regions to display


    toptitle='File: ' + file
    !X.range = 0
    !P.noclip = 1
    ix = LINDGEN(npp)

REPLOT:

    IF screen EQ 'L' THEN BEGIN			; LOWRES
        PRINT, '  Plotting to low res X-window'
        xwinsz=500		; 616
        ywinsz=400		; 800
        pchrsz=1.1		; 1.6
        ochrsz=0.9		; 1.4 xyouts
    ENDIF ELSE BEGIN				; HIRES
        PRINT, '  Plotting to high res X-window'
        xwinsz= 900
        ywinsz= 720
        pchrsz= 1.5
        ochrsz= 1.2
    ENDELSE

    spos = [0.15,0.20,0.95,0.88]

    !P.position=[0,0,0,0]
    !P.charsize = pchrsz
    !P.charthick = 1.9
    !P.thick = 1.9
    !X.thick = 1.0
    !Y.thick = 1.0
    !P.noerase = 1

    !Y.range = 0
    !X.style = 1
    !Y.style = 1
    wind = 0

; Create X window

    SET_PLOT, 'X'
    WINDOW, wind, retain=2, xsize=xwinsz, ysize=ywinsz, 	$
            title='Spectral Plot Pg. 1'

; Print out header lines

    XYOUTS, 1.0, 0.000, date,  /normal, charsize=0.7, alignment=1.

; Plot & overplot spectrum

    yr=[0,max(arr(ix))+0.1*max(arr(ix))]
    !P.POSITION = spos

     if ( ptt ) then begin    ;ptt = 1

     ;print, 'ptt = 1', ptt
     PLOT, xar[ix], arr[ix],psym=3, 		$
           xtitle='Wavenumber [cm-1]', 		$
           ytitle='Transmission',  	 		$
           subtitle=header, 				$
           title=toptitle, 				$
           yrange=yr,				$
           xtickformat='(f7.2)', 			$
           ytickformat='(f5.2)'
     endif else begin
          ;print, 'ptt = 0', ptt
           PLOT, xar[ix], arr[ix], linestyle=0, 		$
           xtitle='Wavenumber [cm-1]', 		$
           ytitle='Transmission',  	 		$
           subtitle=header, 				$
           title=toptitle, 				$
           yrange=yr,				$
           xtickformat='(f7.2)', 			$
           ytickformat='(f5.2)'
     endelse



       ; OPLOT, !X.crange, [0,0]


; Plotting fit regions to Postscript

    SET_PLOT, 'PS'
    PRINT, '  Postscript plot saved to file: ', pstfil
    IF encap EQ 1 THEN PRINT, '  Creating Encapsulated PostScript file.'

    IF orient EQ 'P' THEN BEGIN		    		; PORTRAIT
        PRINT, '  Setting PostScript to "Portrait" mode.'
        DEVICE, /portrait, xsize = 7.8, ysize = 10.3, 		$
                /inches, xoffset = 0.35, yoffset = 0.35,	$
                filename = pstfil, encapsulated=encap
        spos = [0.15,0.20,0.95,0.85]
        xoff = 0.05
    ENDIF ELSE BEGIN					; LANDSCAPE
        PRINT, '  Setting PostScript to "Landscape" mode.'
        DEVICE, /landscape, xsize = 10.3, ysize = 7.8, 		$
                /inches, xoffset = .35, yoffset = 10.65,	$
                filename = pstfil,  encapsulated=encap
        spos = [0.22,0.15,0.775,0.787]
        xoff = 0.12
    ENDELSE
    PRINT, ''

    pchrsz= 1.5
    ochrsz= 1.1

    !P.position=[0,0,0,0]
    !P.charsize = pchrsz
    !P.charthick = 3.4
    !P.thick = 3.1
    !X.thick = 3.4
    !Y.thick = 3.4
    !P.noerase = 1
;   !X.range = 0
    !Y.range = 0
    !X.style = 1


; Print out header lines


    XYOUTS, 1.0, 0.000, date,  /normal, charsize=0.5, alignment=1.

; Plot spectra

;print, ptt
     !P.POSITION = spos

     if ( ptt ) then begin    ;ptt = 1

     ;print, 'ptt = 1', ptt
     PLOT, xar[ix], arr[ix],linestyle=1, 		$
           xtitle='Wavenumber [cm-1]', 		$
           ytitle='Transmission',  	 		$
           subtitle=header, 				$
           title=toptitle, 				$
           yrange=yr,				$
           xtickformat='(f7.2)', 			$
           ytickformat='(f5.2)'
     endif else begin
          ;print, 'ptt = 0', ptt
             PLOT, xar[ix], arr[ix], linestyle=0, 		$
           xtitle='Wavenumber [cm-1]', 		$
           ytitle='Transmission',  	 		$
           subtitle=header, 				$
           title=toptitle, 				$
           yrange=yr,				$
           xtickformat='(f7.2)', 			$
           ytickformat='(f5.2)'
     endelse

     OPLOT, !X.crange, [0,0]

    DEVICE, /Close_File


    READ, x1, 		$
    PROMPT=' Enter flag or new low wv# ( 0-all, 1-quit, 2-title, 3-reread file): '

    IF x1 EQ 0 THEN BEGIN
        !X.range = 0
        !X.style = 1
        ix = LINDGEN(npp)
        GOTO, REPLOT
    ENDIF ELSE IF x1 EQ 1 THEN BEGIN
        RETURN
    ENDIF ELSE IF x1 EQ 2 THEN BEGIN
        READ, toptitle, PROMPT=' Enter title: '
        GOTO, REPLOT
    ENDIF ELSE IF x1 EQ 3 THEN BEGIN
        GOTO, REREADFILE
    ENDIF ELSE BEGIN
        READ, x2, prompt='  enter high wavenumber: '
        !X.range=[ x1, x2 ]
        ;print , x1, x2
        !X.style = 1
        nx = VALUE_LOCATE( xar, [x1, x2] )
        ;print , nx
        ix = nx[0] + LINDGEN(nx[1]-nx[0])
        ;print, xar[ix[0]], xar[nx]
        GOTO, REPLOT
    ENDELSE

    RETURN
    END


PRO Usage

    PRINT, ''
    PRINT, "usage: bnrplt, file='file', screen='X', orient='Y', encap=0, ftype='Z'"
    PRINT, ''
    PRINT, '  This routine plots bnr formatted spectrum files.'
    PRINT, ''
    PRINT, '  file   - bnr formatted spectrum file name.'
    PRINT, ''
    PRINT, '  screen - either L(ow) or H(igh) resolution X-window plot.'
    PRINT, ''
    PRINT, '  orient - either P(ortrait) or L(andscape) postscript file.'
    PRINT, ''
    PRINT, '  encap  - either 0 or 1, 1 makes an encapsulated postscript file.'
    PRINT, ''
    PRINT, '  ftype  - C program written, L(ittle) or B(ig) endian.
    PRINT, ''
    PRINT, 'Default is low res, landscape, not encapsulated, little endian.'
    PRINT, "example: IDL>bnrplt, file='B81103.0050-0055', screen='h'"
    PRINT, ''
    RETURN
    END
