function bnr_init, bnr, filename, ftype

; read sfit bnr file


   if ( ftype eq 'b' ) then 			$
      openr, bflun, filename, /get_lun, error=ioerr, /f77_unformatted, /swap_endian	$
   else if ( ftype eq 'c' ) then 		$
      openr, bflun, filename, error=ioerr, /get_lun 		$
   else					$
      openr, bflun, filename, error=ioerr, /get_lun ,/f77_unformatted

;openr, bflun, filename, /get_lun, error=ioerr, /f77_unformatted , /swap_endian

   if (ioerr ne 0) then begin
      printf,-2,filename, '  :  ', !err_string
      return,0
   endif

   string=''
   integer=0
   double=0.0d
   double2=0.0d
   double3=0.0d
   lon=0l

; init to 80 characters so can read 80 char title
	buf = string(replicate(32b,80))
	readu, bflun, buf
	print, buf
	readu, bflun, double, double2, double3, lon

   maxpnts = lon

   bnr = {     $
       title           : '',              $
	    startwavenum    : 0.0d,            $
	    stopwavenum     : 0.0d,            $
	    spacing         : 0.0d,            $
	    numpoints       : 0l,              $
	    data            : fltarr(maxpnts), $
	    nu              : dblarr(maxpnts), $
	    bnrfile_name    : ''               $
	    }

	bnr.title  = buf
	bnr.bnrfile_name=filename
	bnr.startwavenum=double
	bnr.stopwavenum=double2
	bnr.spacing=double3
	bnr.numpoints=lon
	ary=fltarr(bnr.numpoints)
	readu,bflun,ary
	bnr.data(0:bnr.numpoints-1) = ary(0:bnr.numpoints-1)
	bnr.nu(0:bnr.numpoints-1) = findgen(bnr.numpoints) * bnr.spacing + bnr.startwavenum

free_lun,bflun
return,1
end
