; read in sb.ctl file --------------------------------------------------------------------

; only reads a subset of the file!
; reads in output filenames

function readsbctl4, ctl, file

   print, 'Readsbctl4 input file : ', file

	openr, lun, file, /get_lun, error=ioerr
	if( ioerr ne 0 ) then begin
		printf, -2, !err_string
		return, 1
	endif

   ctl = { $
      terrprt        : 'file.out.total',           $
      terrvmr        : 'file.out.total.vmr',       $
      ranprt         : 'file.out.srandom',         $
      ranvmr         : 'file.out.srandom.vmr',     $
      sysprt         : 'file.out.ssystematic',     $
      sysvmr         : 'file.out.ssystematic.vmr', $
      errsum         : 'file.out.error.summary',   $
      erravk         : 'file.out.avk',             $
      n              : 8                           $ ; parameters in sb.ctl that we are getting
   }

   for i=0, ctl.n-1 do begin

      point_lun, lun, 0
      ;print, i, '  ', ctl.(i)
      while( not eof(lun) )do begin
         buf = ''
         readf, lun, buf
         ;print, buf
         if( strmid( strtrim( buf, 2 ), 0, strlen(ctl.(i))) EQ ctl.(i) )then begin
            ;print, ctl.(i)
            ;print, buf
            subs = strsplit( buf, /extract, count=count )
            ctl.(i) = subs[count-1]
            ;print, ctl.(i)
         endif

       endwhile

   endfor

   print, 'Read sb control file done.'

	free_lun, lun
   return, 0

stop
end
