!        Generated by TAPENADE     (INRIA, Tropics team)
!  Tapenade 3.6 (r4343) - 10 Feb 2012 10:52
!
!WRF:MODEL_LAYER:INITIALIZATION
!
!  This MODULE holds the routines which are used to perform model start-up operations
!  for the individual domains.  This is the stage after inputting wrfinput and before
!  calling 'integrate'.
!  This MODULE CONTAINS the following routines:
MODULE A_MODULE_PHYSICS_INIT

   USE module_state_description
   USE module_model_constants
   USE module_configure, ONLY : grid_config_rec_type

CONTAINS
!  Differentiation of phy_init in reverse (adjoint) mode:
!   gradient     of useful results: rublten raincv rqccuten rthcuten
!                rainnc rainc rqvblten w0avg snownc rvblten graupelnc
!                rthblten graupelncv snowncv rqvcuten rainncv
!   with respect to varying inputs: rublten raincv rqccuten rthcuten
!                rainnc rainc rqvblten w0avg snownc rvblten graupelnc
!                rthblten graupelncv snowncv rqvcuten rainncv
!   RW status of diff variables: rublten:in-out raincv:in-out rqccuten:in-out
!                rthcuten:in-out rainnc:in-out rainc:in-out rqvblten:in-out
!                w0avg:in-out snownc:in-out rvblten:in-out graupelnc:in-out
!                rthblten:in-out graupelncv:in-out snowncv:in-out
!                rqvcuten:in-out rainncv:in-out
!=================================================================
!EMBCK new
! temporary
!                        num_roof_layers,num_wall_layers,        & 
!                        num_road_layers,                        & 
! WA 12/21/09
! WA 9/27/10
! WA 2/22/11
  SUBROUTINE A_PHY_INIT(id, config_flags, dt, restart, zfull, zhalf, &
&    p_top, tsk, radt, bldt, cudt, mpdt, rucuten, rvcuten, rthcuten, &
&    rthcutenb, rqvcuten, rqvcutenb, rqrcuten, rqccuten, rqccutenb, &
&    rqscuten, rqicuten, rushten, rvshten, rthshten, rqvshten, rqrshten, &
&    rqcshten, rqsshten, rqishten, rqgshten, rublten, rubltenb, rvblten, &
&    rvbltenb, rthblten, rthbltenb, rqvblten, rqvbltenb, rqcblten, &
&    rqiblten, rthraten, rthratenlw, rthratensw, stepbl, stepra, stepcu, &
&    w0avg, w0avgb, rainnc, rainncb, rainc, raincb, raincv, raincvb, &
&    rainncv, rainncvb, snownc, snowncb, snowncv, snowncvb, graupelnc, &
&    graupelncb, graupelncv, graupelncvb, nca, swrad_scat, cldefi, lowlyr&
&    , mass_flux, rthften, rqvften, cldfra, cldfra_old, glw, gsw, emiss, &
&    embck, lu_index, landuse_isice, landuse_lucats, landuse_luseas, &
&    landuse_isn, lu_state, xlat, xlong, albedo, albbck, gmt, julyr, &
&    julday, levsiz, n_ozmixm, n_aerosolc, paerlev, alevsiz, no_src_types, tmn, xland, znt, z0, &
&    ust, mol, pblh, tke_pbl, exch_h, thc, snowc, mavail, hfx, qfx, &
&    rainbl, tslb, zs, dzs, num_soil_layers, warm_rain, adv_moist_cond, &
&    apr_gr, apr_w, apr_mc, apr_st, apr_as, apr_capma, apr_capme, &
&    apr_capmi, xice, xicem, vegfra, snow, canwat, smstav, smstot, &
&    sfcrunoff, udrunoff, grdflx, acsnow, acsnom, ivgtyp, isltyp, sfcevp&
&    , smois, sh2o, snowh, smfr3d, snoalb, dx, dy, f_ice_phy, f_rain_phy&
&    , f_rimef_phy, mp_restart_state, tbpvs_state, tbpvs0_state, &
&    allowed_to_read, moved, start_of_simulation, lagday, ids, ide, jds, &
&    jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts&
&    , kte, num_urban_ndm,urban_map_zrd,urban_map_zwd,urban_map_gd,urban_map_zd,&
&    urban_map_zdf,urban_map_bd,urban_map_wd,urban_map_gbd,urban_map_fbd, &
&    NUM_URBAN_HI, raincv_a, raincv_b, gd_cloud, gd_cloud2, &
&    gd_cloud_a, gd_cloud2_a, gd_cloud_b, gd_cloud2_b, ozmixm, pin, &
&    m_ps_1, m_ps_2, m_hybi, aerosolc_1, aerosolc_2, rundgdten, rvndgdten&
&    , rthndgdten, rphndgdten, rqvndgdten, rmundgdten, fgdt, stepfg, &
&    cugd_tten, cugd_ttens, cugd_qvten, cugd_qvtens, cugd_qcten, isnowxy&
&    , zsnsoxy, tsnoxy, snicexy, snliqxy, tvxy, tgxy, canicexy, canliqxy&
&    , eahxy, tahxy, cmxy, chxy, fwetxy, sneqvoxy, alboldxy, qsnowxy, &
&    wslakexy, zwtxy, waxy, wtxy, lfmassxy, rtmassxy, stmassxy, woodxy, &
&    stblcpxy, fastcpxy, xsaixy, t2mvxy, t2mbxy, chstarxy, dzr, dzb, dzg&
&    , tr_urb2d, tb_urb2d, tg_urb2d, tc_urb2d, qc_urb2d, xxxr_urb2d, &
&    xxxb_urb2d, xxxg_urb2d, xxxc_urb2d, trl_urb3d, tbl_urb3d, tgl_urb3d&
&    , sh_urb2d, lh_urb2d, g_urb2d, rn_urb2d, ts_urb2d, frc_urb2d, &
&    utype_urb2d, trb_urb4d, tw1_urb4d, tw2_urb4d, tgb_urb4d, tlev_urb3d&
&    , qlev_urb3d, tw1lev_urb3d, tw2lev_urb3d, tglev_urb3d, tflev_urb3d, &
&    sf_ac_urb3d, lf_ac_urb3d, cm_ac_urb3d, sfvent_urb3d, lfvent_urb3d, &
&    sfwin1_urb3d, sfwin2_urb3d, sfw1_urb3d, sfw2_urb3d, sfr_urb3d, &
&    sfg_urb3d, a_u_bep, a_v_bep, a_t_bep, a_q_bep, a_e_bep, b_u_bep, &
&    b_v_bep, b_t_bep, b_q_bep, b_e_bep, dlg_bep, dl_u_bep, sf_bep, &
&    vl_bep, tml, t0ml, hml, h0ml, huml, hvml, tmoml, itimestep, fdob, &
&    t00, p00, tlp, tyr, tyra, tdly, tlag, nyear, nday, tmn_update, achfx&
&    , aclhf, acgrdflx, te_temf, cf3d_temf, wm_temf, massflux_edkf, &
&    entr_edkf, detr_edkf, thl_up, thv_up, rt_up, rv_up, rc_up, u_up, &
&    v_up, frac_up)

    USE module_domain
    USE module_wrf_error

    IMPLICIT NONE
!-----------------------------------------------------------------
!-----------------------------------------------------------------
    TYPE(GRID_CONFIG_REC_TYPE) :: config_flags
    INTEGER, INTENT(IN) :: id
    INTEGER, INTENT(IN), OPTIONAL :: tmn_update
    LOGICAL, INTENT(OUT) :: warm_rain, adv_moist_cond
!   LOGICAL , INTENT (IN)       :: FNDSOILW, FNDSNOWH
    LOGICAL, PARAMETER :: fndsoilw=.true., fndsnowh=.true.
    INTEGER, INTENT(IN) :: ids, ide, jds, jde, kds, kde, ims, ime, jms, &
&    jme, kms, kme, its, ite, jts, jte, kts, kte
    INTEGER, INTENT(IN) :: num_soil_layers
    INTEGER, INTENT(IN) :: lagday
    INTEGER, INTENT(OUT), OPTIONAL :: nyear
    REAL, INTENT(OUT), OPTIONAL :: nday
    LOGICAL, INTENT(IN) :: start_of_simulation
    REAL, INTENT(IN) :: dt, p_top, dx, dy
    LOGICAL, INTENT(IN) :: restart
    REAL, INTENT(IN) :: radt, bldt, cudt, mpdt
    REAL, INTENT(IN) :: swrad_scat
    REAL, DIMENSION(kms:kme), INTENT(IN) :: zfull, zhalf
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(IN) :: tsk, xlat, xlong
    INTEGER, INTENT(IN) :: levsiz, n_ozmixm
    INTEGER, INTENT(IN) :: paerlev, n_aerosolc
    INTEGER,      INTENT(IN   )    ::   alevsiz, no_src_types
    REAL, DIMENSION(ims:ime, levsiz, jms:jme, n_ozmixm), OPTIONAL, &
&    INTENT(INOUT) :: ozmixm
    REAL, DIMENSION(levsiz), OPTIONAL, INTENT(INOUT) :: pin
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: m_ps_1&
&    , m_ps_2
    REAL, DIMENSION(paerlev), OPTIONAL, INTENT(INOUT) :: m_hybi
    REAL, DIMENSION(ims:ime, paerlev, jms:jme, n_aerosolc), OPTIONAL, &
&    INTENT(INOUT) :: aerosolc_1, aerosolc_2
    REAL, DIMENSION(ims:ime, num_soil_layers, jms:jme), INTENT(INOUT) ::&
&    smois, sh2o, tslb
    REAL, DIMENSION(ims:ime, num_soil_layers, jms:jme), INTENT(OUT) :: &
&    smfr3d
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: snow, snowc, &
&    snowh, canwat, smstav, smstot, sfcrunoff, udrunoff, sfcevp, grdflx, &
&    acsnow, xice, xicem, vegfra, acsnom
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: achfx&
&    , aclhf, acgrdflx
    INTEGER, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: ivgtyp, &
&    isltyp
! rad
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: rthraten&
&    , rthratenlw, rthratensw, cldfra
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) ::&
&    cldfra_old
!EMBCK new
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: gsw, albedo, &
&    albbck, glw, emiss, embck
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: snoalb
    REAL, INTENT(IN) :: gmt
    INTEGER, INTENT(OUT) :: stepra, stepbl, stepcu
    INTEGER, INTENT(IN) :: julyr, julday
! cps
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: rucuten, rvcuten, &
&    rthcuten, rqvcuten, rqrcuten, rqccuten, rqscuten, rqicuten, rushten&
&    , rvshten, rthshten, rqvshten, rqrshten, rqcshten, rqsshten, &
&    rqishten, rqgshten
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: rthcutenb, rqvcutenb, &
&    rqccutenb
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: w0avg
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: w0avgb
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(OUT) :: mass_flux, apr_gr&
&    , apr_w, apr_mc, apr_st, apr_as, apr_capma, apr_capme, apr_capmi
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(OUT) :: rthften, &
&    rqvften
    REAL, DIMENSION(ims:ime, jms:jme) :: rainnc, rainc, raincv, rainncv&
&    , snownc, snowncv, graupelnc, graupelncv
    REAL, DIMENSION(ims:ime, jms:jme) :: rainncb, raincb, raincvb, &
&    rainncvb, snowncb, snowncvb, graupelncb, graupelncvb
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(OUT) :: cldefi, nca
    INTEGER, DIMENSION(ims:ime, jms:jme), INTENT(OUT) :: lowlyr
!pbl
! soil layer
    REAL, DIMENSION(num_soil_layers), INTENT(INOUT) :: zs, dzs
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: rublten, rvblten, &
&    rthblten, rqvblten, rqcblten, rqiblten, exch_h, tke_pbl
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: rubltenb, rvbltenb, &
&    rthbltenb, rqvbltenb
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(OUT), OPTIONAL ::&
&    massflux_edkf, entr_edkf, detr_edkf, thl_up, thv_up, rt_up, rv_up, &
&    rc_up, u_up, v_up, frac_up
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(OUT) ::&
&    cugd_tten, cugd_ttens, cugd_qvten, cugd_qvtens, cugd_qcten
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: xland, znt, z0, &
&    ust, mol, lu_index, pblh, thc, mavail, hfx, qfx, rainbl
    INTEGER, INTENT(INOUT) :: landuse_isice, landuse_lucats
    INTEGER, INTENT(INOUT) :: landuse_luseas, landuse_isn
    REAL, DIMENSION(:), INTENT(INOUT) :: lu_state
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: tmn
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT), OPTIONAL :: tyr
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT), OPTIONAL :: tyra
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT), OPTIONAL :: tdly
    REAL, DIMENSION(ims:ime, lagday, jms:jme), INTENT(INOUT), OPTIONAL &
&    :: tlag
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: gd_cloud, gd_cloud2, gd_cloud_a, gd_cloud2_a, gd_cloud_b, &
&    gd_cloud2_b
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: raincv_a, &
&    raincv_b
!Noah-MP
    INTEGER, DIMENSION(ims:ime, jms:jme), OPTIONAL :: isnowxy
    REAL, DIMENSION(ims:ime, -2:num_soil_layers, jms:jme), OPTIONAL :: &
&    zsnsoxy
    REAL, DIMENSION(ims:ime, -2:0, jms:jme), OPTIONAL :: tsnoxy
    REAL, DIMENSION(ims:ime, -2:0, jms:jme), OPTIONAL :: snicexy
    REAL, DIMENSION(ims:ime, -2:0, jms:jme), OPTIONAL :: snliqxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: tvxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: tgxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: canicexy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: canliqxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: eahxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: tahxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: cmxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: chxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: fwetxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: sneqvoxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: alboldxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: qsnowxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: wslakexy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: zwtxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: waxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: wtxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: lfmassxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: rtmassxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: stmassxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: woodxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: stblcpxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: fastcpxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: xsaixy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: t2mvxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: t2mbxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: chstarxy
!mp
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(OUT) :: f_ice_phy&
&    , f_rain_phy, f_rimef_phy
    REAL, DIMENSION(:), INTENT(INOUT) :: mp_restart_state, tbpvs_state, &
&    tbpvs0_state
    LOGICAL, INTENT(IN) :: allowed_to_read, moved
! ocean mixed layer
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: tml, &
&    t0ml, hml, h0ml, huml, hvml, tmoml
!fdda
    REAL, OPTIONAL, INTENT(IN) :: fgdt
    INTEGER, OPTIONAL, INTENT(OUT) :: stepfg
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) ::&
&    rundgdten, rvndgdten, rthndgdten, rphndgdten, rqvndgdten
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    rmundgdten
!URBAN
!   REAL, DIMENSION(1:num_roof_layers), INTENT(INOUT) :: DZR   !urban
!   REAL, DIMENSION(1:num_wall_layers), INTENT(INOUT) :: DZB   !urban
!   REAL, DIMENSION(1:num_road_layers), INTENT(INOUT) :: DZG   !urban
!urban
    REAL, DIMENSION(num_soil_layers), OPTIONAL, INTENT(INOUT) :: dzr
!urban
    REAL, DIMENSION(num_soil_layers), OPTIONAL, INTENT(INOUT) :: dzb
!urban
    REAL, DIMENSION(num_soil_layers), OPTIONAL, INTENT(INOUT) :: dzg
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    tr_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    tb_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    tg_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    tc_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    qc_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    xxxr_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    xxxb_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    xxxg_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    xxxc_urb2d
!   REAL, DIMENSION(ims:ime, 1:num_roof_layers, jms:jme), INTENT(INOUT) :: TRL_URB3D !urban
!   REAL, DIMENSION(ims:ime, 1:num_wall_layers, jms:jme), INTENT(INOUT) :: TBL_URB3D !urban
!   REAL, DIMENSION(ims:ime, 1:num_road_layers, jms:jme), INTENT(INOUT) :: TGL_URB3D !urban
!urban
    REAL, DIMENSION(ims:ime, num_soil_layers, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: trl_urb3d
!urban
    REAL, DIMENSION(ims:ime, num_soil_layers, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tbl_urb3d
!urban
    REAL, DIMENSION(ims:ime, num_soil_layers, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tgl_urb3d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    sh_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    lh_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    g_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    rn_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    ts_urb2d
!urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    frc_urb2d
!urban
    INTEGER, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    utype_urb2d
    INTEGER , INTENT(IN)        :: num_urban_ndm
    INTEGER , INTENT(IN)        :: urban_map_zrd
    INTEGER , INTENT(IN)        :: urban_map_zwd
    INTEGER , INTENT(IN)        :: urban_map_gd
    INTEGER , INTENT(IN)        :: urban_map_zd
    INTEGER , INTENT(IN)        :: urban_map_zdf
    INTEGER , INTENT(IN)        :: urban_map_bd
    INTEGER , INTENT(IN)        :: urban_map_wd
    INTEGER , INTENT(IN)        :: urban_map_gbd
    INTEGER , INTENT(IN)        :: urban_map_fbd
    INTEGER , INTENT(IN)        :: num_urban_hi
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_zrd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: trb_urb4d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_zwd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tw1_urb4d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_zwd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tw2_urb4d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_gd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tgb_urb4d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_bd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tlev_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_bd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: qlev_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_wd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tw1lev_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_wd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tw2lev_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_gbd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tglev_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_fbd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tflev_urb3d
!multi-layer UCM
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    lf_ac_urb3d
!multi-layer UCM
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    sf_ac_urb3d
!multi-layer UCM
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    cm_ac_urb3d
!multi-layer UCM
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    sfvent_urb3d
!multi-layer UCM
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    lfvent_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_wd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfwin1_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_wd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfwin2_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, num_urban_ndm, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfg_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_zdf, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfr_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_zd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfw1_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_zd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfw2_urb3d
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: a_u_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: a_v_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: a_t_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: a_q_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: a_e_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: b_u_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: b_v_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: b_t_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: b_q_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: b_e_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: vl_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: dlg_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: sf_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: dl_u_bep
!obs fdda
    INTEGER, OPTIONAL, INTENT(IN) :: itimestep
    TYPE(FDOB_TYPE), OPTIONAL, INTENT(INOUT) :: fdob
! for obs-nudging base-state calcn
    REAL, OPTIONAL, INTENT(IN) :: p00, t00, tlp
! WA 12/21/09
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(OUT) ::&
&    te_temf, cf3d_temf
! WA 2/22/11
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(OUT) :: wm_temf
! Local data
    REAL :: alblnd, zzlnd, zzwtr, thinld, xmava, cen_lat, pptop
    REAL, DIMENSION(kms:kme) :: sfull, shalf
    REAL :: obs_twindo_cg, obs_twindo
    CHARACTER(len=256) :: mminlu_loc
    CHARACTER(len=512) :: message
    INTEGER :: iswater
    INTEGER :: isice
    INTEGER :: isurban
    INTEGER :: sf_urban_physics
    INTEGER :: sf_ocean_physics
    REAL :: oml_hml0
    LOGICAL :: usemonalb
    LOGICAL :: rdmaxalb
    INTEGER :: mfshconv
    INTEGER :: i, j, k, itf, jtf, ktf, n
    INTEGER :: myproc
    INTEGER :: branch
    INTRINSIC MIN0
    INTRINSIC TRIM
    INTRINSIC PRESENT
!-----------------------------------------------------------------
!-- should be from the namelist
    IF (ite .GT. ide - 1) THEN
      itf = ide - 1
    ELSE
      itf = ite
    END IF
    IF (jte .GT. jde - 1) THEN
      jtf = jde - 1
    ELSE
      jtf = jte
    END IF
!-- temporary fix by ww
    IF (.NOT.restart) THEN
!-- initialize common variables
      IF (.NOT.moved) THEN
        CALL PUSHCONTROL2B(0)
      ELSE
        CALL PUSHCONTROL2B(1)
      END IF
    ELSE
      CALL PUSHCONTROL2B(2)
    END IF
    CALL MP_INIT_B(rainnc, rainncb, snownc, snowncb, graupelnc, &
&             graupelncb, config_flags, restart, warm_rain, &
&             adv_moist_cond, mpdt, dt, dx, dy, lowlyr, f_ice_phy, &
&             f_rain_phy, f_rimef_phy, mp_restart_state, tbpvs_state, &
&             tbpvs0_state, allowed_to_read, start_of_simulation, ids, &
&             ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, its&
&             , ite, jts, jte, kts, kte)
    CALL CU_INIT_B(dx, stepcu, cudt, dt, rucuten, rvcuten, rthcuten, &
&             rthcutenb, rqvcuten, rqvcutenb, rqrcuten, rqccuten, &
&             rqccutenb, rqscuten, rqicuten, nca, rainc, raincb, raincv, &
&             raincvb, w0avg, w0avgb, config_flags, restart, cldefi, &
&             lowlyr, mass_flux, rthften, rqvften, apr_gr, apr_w, apr_mc&
&             , apr_st, apr_as, apr_capma, apr_capme, apr_capmi, &
&             cugd_tten, cugd_ttens, cugd_qvten, cugd_qvtens, cugd_qcten&
&             , allowed_to_read, start_of_simulation, ids, ide, jds, jde&
&             , kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, &
&             jte, kts, kte)
    CALL BL_INIT_B(stepbl, bldt, dt, rublten, rubltenb, rvblten, &
&             rvbltenb, rthblten, rthbltenb, rqvblten, rqvbltenb, &
&             rqcblten, rqiblten, tsk, tmn, config_flags, restart, ust, &
&             lowlyr, tslb, zs, dzs, num_soil_layers, tke_pbl, mfshconv, &
&             massflux_edkf, entr_edkf, detr_edkf, thl_up, thv_up, rt_up&
&             , rv_up, rc_up, u_up, v_up, frac_up, exch_h, vegfra, snow, &
&             snowc, canwat, smstav, smstot, sfcrunoff, udrunoff, acsnow&
&             , acsnom, ivgtyp, isltyp, isurban, smois, smfr3d, mavail, &
&             snowh, sh2o, snoalb, fndsoilw, fndsnowh, rdmaxalb, znt, &
&             xland, xice, sfcevp, grdflx, TRIM(mminlu_loc), isnowxy, &
&             zsnsoxy, tsnoxy, snicexy, snliqxy, tvxy, tgxy, canicexy, &
&             canliqxy, eahxy, tahxy, cmxy, chxy, fwetxy, sneqvoxy, &
&             alboldxy, qsnowxy, wslakexy, zwtxy, waxy, wtxy, lfmassxy, &
&             rtmassxy, stmassxy, woodxy, stblcpxy, fastcpxy, xsaixy, &
&             t2mvxy, t2mbxy, chstarxy, allowed_to_read, &
&             start_of_simulation, te_temf, cf3d_temf, wm_temf, dzr, dzb&
&             , dzg, tr_urb2d, tb_urb2d, tg_urb2d, tc_urb2d, qc_urb2d, &
&             xxxr_urb2d, xxxb_urb2d, xxxg_urb2d, xxxc_urb2d, trl_urb3d, &
&             tbl_urb3d, tgl_urb3d, sh_urb2d, lh_urb2d, g_urb2d, rn_urb2d&
&             , ts_urb2d, frc_urb2d, utype_urb2d, sf_urban_physics, &
&             num_urban_ndm, urban_map_zrd, urban_map_zwd, urban_map_gd, &
&             urban_map_zd, urban_map_zdf, urban_map_bd, urban_map_wd, &
&             urban_map_gbd, urban_map_fbd, trb_urb4d, tw1_urb4d, tw2_urb4d, &
&             tgb_urb4d, tlev_urb3d, qlev_urb3d, tw1lev_urb3d, &
&             tw2lev_urb3d, tglev_urb3d, tflev_urb3d, sf_ac_urb3d, &
&             lf_ac_urb3d, cm_ac_urb3d, sfvent_urb3d, lfvent_urb3d, &
&             sfwin1_urb3d, sfwin2_urb3d, sfw1_urb3d, sfw2_urb3d, &
&             sfr_urb3d, sfg_urb3d, a_u_bep, a_v_bep, a_t_bep, a_q_bep, &
&             a_e_bep, b_u_bep, b_v_bep, b_t_bep, b_q_bep, b_e_bep, &
&             dlg_bep, dl_u_bep, sf_bep, vl_bep, ids, ide, jds, jde, kds&
&             , kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, &
&             kts, kte, achfx, aclhf, acgrdflx, oml_hml0, sf_ocean_physics, tml, &
&             t0ml, hml, h0ml, huml, hvml, tmoml)
    CALL POPCONTROL2B(branch)
    IF (branch .EQ. 0) THEN
      DO j=jtf,jts,-1
        DO i=itf,its,-1
          graupelncvb(i, j) = 0.0
          snowncvb(i, j) = 0.0
          rainncvb(i, j) = 0.0
        END DO
      END DO
    END IF
  END SUBROUTINE A_PHY_INIT
!=================================================================
! WA
!                num_roof_layers,num_wall_layers,num_road_layers,& !Optional urban
!Optional urban
!Optional urban
!Optional urban
!Optional urban
!Optional urban
!Optional urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional multi-layer urban
!Optional oml
  SUBROUTINE BL_INIT_B(stepbl, bldt, dt, rublten, rubltenb, rvblten, &
&    rvbltenb, rthblten, rthbltenb, rqvblten, rqvbltenb, rqcblten, &
&    rqiblten, tsk, tmn, config_flags, restart, ust, lowlyr, tslb, zs, &
&    dzs, num_soil_layers, tke_pbl, mfshconv, massflux_edkf, entr_edkf, &
&    detr_edkf, thl_up, thv_up, rt_up, rv_up, rc_up, u_up, v_up, frac_up&
&    , exch_h, vegfra, snow, snowc, canwat, smstav, smstot, sfcrunoff, &
&    udrunoff, acsnow, acsnom, ivgtyp, isltyp, isurban, smois, smfr3d, &
&    mavail, snowh, sh2o, snoalb, fndsoilw, fndsnowh, rdmaxalb, znt, &
&    xland, xice, sfcevp, grdflx, mminlu, isnowxy, zsnsoxy, tsnoxy, &
&    snicexy, snliqxy, tvxy, tgxy, canicexy, canliqxy, eahxy, tahxy, cmxy&
&    , chxy, fwetxy, sneqvoxy, alboldxy, qsnowxy, wslakexy, zwtxy, waxy, &
&    wtxy, lfmassxy, rtmassxy, stmassxy, woodxy, stblcpxy, fastcpxy, &
&    xsaixy, t2mvxy, t2mbxy, chstarxy, allowed_to_read, &
&    start_of_simulation, te_temf, cf3d_temf, wm_temf, dzr, dzb, dzg, &
&    tr_urb2d, tb_urb2d, tg_urb2d, tc_urb2d, qc_urb2d, xxxr_urb2d, &
&    xxxb_urb2d, xxxg_urb2d, xxxc_urb2d, trl_urb3d, tbl_urb3d, tgl_urb3d&
&    , sh_urb2d, lh_urb2d, g_urb2d, rn_urb2d, ts_urb2d, frc_urb2d, &
&    utype_urb2d, sf_urban_physics, num_urban_ndm, urban_map_zrd,&
&    urban_map_zwd, urban_map_gd, urban_map_zd, urban_map_zdf,urban_map_bd,&
&    urban_map_wd, urban_map_gbd, urban_map_fbd, trb_urb4d, &
&    tw1_urb4d, tw2_urb4d, tgb_urb4d, tlev_urb3d, qlev_urb3d, &
&    tw1lev_urb3d, tw2lev_urb3d, tglev_urb3d, tflev_urb3d, sf_ac_urb3d, &
&    lf_ac_urb3d, cm_ac_urb3d, sfvent_urb3d, lfvent_urb3d, sfwin1_urb3d, &
&    sfwin2_urb3d, sfw1_urb3d, sfw2_urb3d, sfr_urb3d, sfg_urb3d, a_u_bep&
&    , a_v_bep, a_t_bep, a_q_bep, a_e_bep, b_u_bep, b_v_bep, b_t_bep, &
&    b_q_bep, b_e_bep, dlg_bep, dl_u_bep, sf_bep, vl_bep, ids, ide, jds, &
&    jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts&
&    , kte, achfx, aclhf, acgrdflx, oml_hml0, sf_ocean_physics, tml, t0ml, hml, &
&    h0ml, huml, hvml, tmoml)

    USE a_module_bl_surface_drag, ONLY : surface_drag_init_b

    IMPLICIT NONE
!Optional oml
!--------------------------------------------------------------------
!--------------------------------------------------------------------
    TYPE(GRID_CONFIG_REC_TYPE) :: config_flags
    LOGICAL, INTENT(IN) :: restart
    LOGICAL, INTENT(IN) :: fndsoilw, fndsnowh
    LOGICAL, INTENT(IN) :: rdmaxalb
    INTEGER, INTENT(IN) :: ids, ide, jds, jde, kds, kde, ims, ime, jms, &
&    jme, kms, kme, its, ite, jts, jte, kts, kte
    INTEGER, INTENT(IN) :: num_soil_layers
    INTEGER, INTENT(IN) :: sf_urban_physics
    REAL, INTENT(IN) :: dt, bldt
    INTEGER, INTENT(INOUT) :: stepbl
    REAL, DIMENSION(ims:ime, num_soil_layers, jms:jme), INTENT(OUT) :: &
&    smfr3d
    REAL, DIMENSION(ims:ime, num_soil_layers, jms:jme), INTENT(INOUT) ::&
&    smois, sh2o, tslb
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: snow, snowh, &
&    snowc, snoalb, canwat, mavail, smstav, smstot, sfcrunoff, udrunoff, &
&    acsnow, vegfra, acsnom, sfcevp, grdflx, ust, znt, xland, xice
    INTEGER, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: ivgtyp, &
&    isltyp, lowlyr
    REAL, DIMENSION(num_soil_layers), INTENT(INOUT) :: zs, dzs
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: rublten, rvblten, &
&    exch_h, rthblten, rqvblten, rqcblten, rqiblten, tke_pbl
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: rubltenb, rvbltenb, &
&    rthbltenb, rqvbltenb
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(OUT), OPTIONAL ::&
&    massflux_edkf, entr_edkf, detr_edkf, thl_up, thv_up, rt_up, rv_up, &
&    rc_up, u_up, v_up, frac_up
! WRF JP
    INTEGER, INTENT(IN) :: mfshconv
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(IN) :: tsk
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: tmn
    CHARACTER(len=*), INTENT(IN) :: mminlu
    LOGICAL, INTENT(IN) :: allowed_to_read
    INTEGER, INTENT(IN) :: isurban
    INTEGER :: isn, isfc
    INTEGER :: k
!WA 
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(OUT) ::&
&    te_temf, cf3d_temf
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(OUT) :: wm_temf
!Noah-MP
    INTEGER, DIMENSION(ims:ime, jms:jme), OPTIONAL :: isnowxy
    REAL, DIMENSION(ims:ime, -2:num_soil_layers, jms:jme), OPTIONAL :: &
&    zsnsoxy
    REAL, DIMENSION(ims:ime, -2:0, jms:jme), OPTIONAL :: tsnoxy
    REAL, DIMENSION(ims:ime, -2:0, jms:jme), OPTIONAL :: snicexy
    REAL, DIMENSION(ims:ime, -2:0, jms:jme), OPTIONAL :: snliqxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: tvxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: tgxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: canicexy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: canliqxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: eahxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: tahxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: cmxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: chxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: fwetxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: sneqvoxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: alboldxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: qsnowxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: wslakexy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: zwtxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: waxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: wtxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: lfmassxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: rtmassxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: stmassxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: woodxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: stblcpxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: fastcpxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: xsaixy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: t2mvxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: t2mbxy
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: chstarxy
!URBAN
!   REAL, DIMENSION(1:num_roof_layers), INTENT(INOUT) :: DZR  !Optional urban
!   REAL, DIMENSION(1:num_wall_layers), INTENT(INOUT) :: DZB  !Optional urban
!   REAL, DIMENSION(1:num_road_layers), INTENT(INOUT) :: DZG  !Optional urban
!Optional urban
    REAL, DIMENSION(num_soil_layers), OPTIONAL, INTENT(INOUT) :: dzr
!Optional urban
    REAL, DIMENSION(num_soil_layers), OPTIONAL, INTENT(INOUT) :: dzb
!Optional urban
    REAL, DIMENSION(num_soil_layers), OPTIONAL, INTENT(INOUT) :: dzg
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    tr_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    tb_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    tg_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    tc_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    qc_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    xxxr_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    xxxb_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    xxxg_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    xxxc_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    sh_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    lh_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    g_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    rn_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    ts_urb2d
!Optional urban
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    frc_urb2d
!Optional urban
    INTEGER, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    utype_urb2d
!    REAL, DIMENSION( ims:ime, 1:num_roof_layers, jms:jme ), INTENT(INOUT) :: TRL_URB3D !Optional urban
!    REAL, DIMENSION( ims:ime, 1:num_wall_layers, jms:jme ), INTENT(INOUT) :: TBL_URB3D !Optional urban
!    REAL, DIMENSION( ims:ime, 1:num_road_layers, jms:jme ), INTENT(INOUT) :: TGL_URB3D !Optional urban
!Optional urban
    REAL, DIMENSION(ims:ime, num_soil_layers, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: trl_urb3d
!Optional urban
    REAL, DIMENSION(ims:ime, num_soil_layers, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tbl_urb3d
!Optional urban
    REAL, DIMENSION(ims:ime, num_soil_layers, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tgl_urb3d
    INTEGER, INTENT(IN) :: num_urban_ndm
    INTEGER, INTENT(IN) :: urban_map_zrd
    INTEGER, INTENT(IN) :: urban_map_zwd
    INTEGER, INTENT(IN) :: urban_map_gd
    INTEGER, INTENT(IN) :: urban_map_zd
    INTEGER, INTENT(IN) :: urban_map_zdf
    INTEGER, INTENT(IN) :: urban_map_bd
    INTEGER, INTENT(IN) :: urban_map_wd
    INTEGER, INTENT(IN) :: urban_map_gbd
    INTEGER, INTENT(IN) :: urban_map_fbd
!Optional UCM
    REAL, DIMENSION(ims:ime, urban_map_zrd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: trb_urb4d
!Optional UCM
    REAL, DIMENSION(ims:ime, urban_map_zwd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tw1_urb4d
!Optional UCM
    REAL, DIMENSION(ims:ime, urban_map_zwd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tw2_urb4d
!Optional UCM
    REAL, DIMENSION(ims:ime, urban_map_gd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tgb_urb4d
!Optional UCM
    REAL, DIMENSION(ims:ime, urban_map_bd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tlev_urb3d
!Optional UCM
    REAL, DIMENSION(ims:ime, urban_map_bd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: qlev_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_wd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tw1lev_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_wd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tw2lev_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_gbd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tglev_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_fbd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: tflev_urb3d
!multi-layer UCM
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    lf_ac_urb3d
!multi-layer UCM
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    sf_ac_urb3d
!multi-layer UCM
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    cm_ac_urb3d
!multi-layer UCM
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    sfvent_urb3d
!multi-layer UCM
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: &
&    lfvent_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_wd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfwin1_urb3d
! multi-layer UCM
    REAL, DIMENSION(ims:ime, urban_map_wd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfwin2_urb3d
!Optional UCM
    REAL, DIMENSION(ims:ime, urban_map_zd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfw1_urb3d
!Optional UCM
    REAL, DIMENSION(ims:ime, urban_map_zd, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfw2_urb3d
!Optional UCM
    REAL, DIMENSION(ims:ime, urban_map_zdf, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfr_urb3d
!Optional UCM
    REAL, DIMENSION(ims:ime, num_urban_ndm, jms:jme), OPTIONAL, &
&    INTENT(INOUT) :: sfg_urb3d
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: a_u_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: a_v_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: a_t_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: a_q_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: a_e_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: b_u_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: b_v_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: b_t_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: b_q_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: b_e_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: vl_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: dlg_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: sf_bep
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: dl_u_bep
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: achfx&
&    , aclhf, acgrdflx
! Optional OML variables
    REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(INOUT) :: tml, &
&    t0ml, hml, h0ml, huml, hvml, tmoml
    INTEGER, OPTIONAL, INTENT(IN) :: sf_ocean_physics
    REAL, OPTIONAL, INTENT(IN) :: oml_hml0
    LOGICAL, INTENT(IN) :: start_of_simulation
    INTEGER :: i, j
!local mynn 
    INTEGER :: mynn_closure_level
!-- calculate pbl time step
    INTRINSIC MAX
    INTRINSIC PRESENT
    INTRINSIC NINT
!mynn 
!-- initialize pbl scheme
    SELECT CASE  (config_flags%bl_pbl_physics) 
    CASE (surfdragscheme) 
      CALL SURFACE_DRAG_INIT_B(rublten, rubltenb, rvblten, rvbltenb, &
&                         rthblten, rthbltenb, rqvblten, rqvbltenb, &
&                         restart, ids, ide, jds, jde, kds, kde, ims, ime&
&                         , jms, jme, kms, kme, its, ite, jts, jte, kts, &
&                         kte)
    END SELECT
  END SUBROUTINE BL_INIT_B
!=====================================================================
!  Differentiation of cu_init in reverse (adjoint) mode:
!   gradient     of useful results: raincv rqccuten rthcuten rainc
!                w0avg rqvcuten
!   with respect to varying inputs: raincv rqccuten rthcuten rainc
!                w0avg rqvcuten
!==================================================================
  SUBROUTINE CU_INIT_B(dx, stepcu, cudt, dt, rucuten, rvcuten, rthcuten, &
&    rthcutenb, rqvcuten, rqvcutenb, rqrcuten, rqccuten, rqccutenb, &
&    rqscuten, rqicuten, nca, rainc, raincb, raincv, raincvb, w0avg, &
&    w0avgb, config_flags, restart, cldefi, lowlyr, mass_flux, rthften, &
&    rqvften, apr_gr, apr_w, apr_mc, apr_st, apr_as, apr_capma, apr_capme&
&    , apr_capmi, cugd_tten, cugd_ttens, cugd_qvten, cugd_qvtens, &
&    cugd_qcten, allowed_to_read, start_of_simulation, ids, ide, jds, jde&
&    , kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, &
&    kte)

    USE a_module_cu_du, ONLY : ducuinit_b

    IMPLICIT NONE
!------------------------------------------------------------------
!------------------------------------------------------------------
    TYPE(GRID_CONFIG_REC_TYPE) :: config_flags
    LOGICAL, INTENT(IN) :: restart
    INTEGER, INTENT(IN) :: ids, ide, jds, jde, kds, kde, ims, ime, jms, &
&    jme, kms, kme, its, ite, jts, jte, kts, kte
    REAL, INTENT(IN) :: dt, cudt, dx
    LOGICAL, INTENT(IN) :: start_of_simulation
    LOGICAL, INTENT(IN) :: allowed_to_read
    INTEGER, INTENT(INOUT) :: stepcu
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: rucuten&
&    , rvcuten, rthcuten, rqvcuten, rqccuten, rqrcuten, rqicuten, &
&    rqscuten
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: &
&    rthcutenb
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), OPTIONAL, INTENT(INOUT) &
&    :: cugd_tten, cugd_ttens, cugd_qvten, cugd_qvtens, cugd_qcten
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: w0avg
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: w0avgb
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: rthften, &
&    rqvften
    REAL, DIMENSION(ims:ime, jms:jme) :: rainc, raincv
    REAL, DIMENSION(ims:ime, jms:jme) :: raincb, raincvb
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(OUT) :: cldefi
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: nca
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: mass_flux, &
&    apr_gr, apr_w, apr_mc, apr_st, apr_as, apr_capma, apr_capme, &
&    apr_capmi
    INTEGER, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: lowlyr
! LOCAL VAR
    INTEGER :: i, j, itf, jtf
    INTEGER :: branch
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: &
&    rqvcutenb
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: &
&    rqccutenb
    INTRINSIC MIN0
    INTRINSIC MAX
    INTRINSIC NINT
    IF (ite .GT. ide - 1) THEN
      itf = ide - 1
    ELSE
      itf = ite
    END IF
    IF (jte .GT. jde - 1) THEN
      jtf = jde - 1
    ELSE
      jtf = jte
    END IF
!-- initialization
    IF (start_of_simulation) THEN
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
!-- deep convection and hybrid deep-shallow convection schemes
    SELECT CASE  (config_flags%cu_physics) 
    CASE (ducuscheme) 
      CALL DUCUINIT_B(rthcuten, rthcutenb, rqvcuten, rqvcutenb, rqccuten&
&                , rqccutenb, rqrcuten, rqicuten, rqscuten, nca, w0avg, &
&                w0avgb, p_qc, p_qr, svp1, svp2, svp3, svpt0, &
&                param_first_scalar, restart, allowed_to_read, ids, ide, &
&                jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, its, &
&                ite, jts, jte, kts, kte)
    END SELECT
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      DO j=jtf,jts,-1
        DO i=itf,its,-1
          raincvb(i, j) = 0.0
          raincb(i, j) = 0.0
        END DO
      END DO
    END IF
  END SUBROUTINE CU_INIT_B
!==================================================================
!  Differentiation of mp_init in reverse (adjoint) mode:
!   gradient     of useful results: rainnc snownc graupelnc
!   with respect to varying inputs: rainnc snownc graupelnc
!==================================================================
! for eta mp
! for eta mp
! eta mp
  SUBROUTINE MP_INIT_B(rainnc, rainncb, snownc, snowncb, graupelnc, &
&    graupelncb, config_flags, restart, warm_rain, adv_moist_cond, mpdt, &
&    dt, dx, dy, lowlyr, f_ice_phy, f_rain_phy, f_rimef_phy, &
&    mp_restart_state, tbpvs_state, tbpvs0_state, allowed_to_read, &
&    start_of_simulation, ids, ide, jds, jde, kds, kde, ims, ime, jms, &
&    jme, kms, kme, its, ite, jts, jte, kts, kte)
    IMPLICIT NONE
!------------------------------------------------------------------
! Arguments
    TYPE(GRID_CONFIG_REC_TYPE) :: config_flags
    LOGICAL, INTENT(IN) :: restart
    LOGICAL, INTENT(OUT) :: warm_rain, adv_moist_cond
    REAL, INTENT(IN) :: mpdt, dt, dx, dy
    LOGICAL, INTENT(IN) :: start_of_simulation
    INTEGER, INTENT(IN) :: ids, ide, jds, jde, kds, kde, ims, ime, jms, &
&    jme, kms, kme, its, ite, jts, jte, kts, kte
    INTEGER, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: lowlyr
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: rainnc, snownc, &
&    graupelnc
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: rainncb
    REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: &
&    f_ice_phy, f_rain_phy, f_rimef_phy
    REAL, DIMENSION(:), INTENT(INOUT) :: mp_restart_state, tbpvs_state, &
&    tbpvs0_state
    LOGICAL, INTENT(IN) :: allowed_to_read
! Local
    INTEGER :: i, j, itf, jtf
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: graupelncb
    REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: snowncb
    INTRINSIC MIN0
    IF (ite .GT. ide - 1) THEN
      itf = ide - 1
    ELSE
      itf = ite
    END IF
    IF (jte .GT. jde - 1) THEN
      jtf = jde - 1
    ELSE
      jtf = jte
    END IF
    IF (start_of_simulation) THEN
      DO j=jtf,jts,-1
        DO i=itf,its,-1
          graupelncb(i, j) = 0.0
          snowncb(i, j) = 0.0
          rainncb(i, j) = 0.0
        END DO
      END DO
    END IF
  END SUBROUTINE MP_INIT_B
!==================================================================
END MODULE A_MODULE_PHYSICS_INIT
