!==========================================================================
!==========================================================================
!      Developed by Ying Pan and Yang Zhang, NCSU, Oct. 2009
!            to couple CB05 with MADE/SORGAM-AQ-ISORROPIA
!==========================================================================
!==========================================================================

       MODULE module_data_isrpia_data

!======MODULE OTHR=========================================================
        INTEGER,PRIVATE :: NIONS,NCOMP,NPAIR
        PARAMETER (NCOMP=5, NIONS=7,  NPAIR=13)

        DOUBLE PRECISION   &
              R, IMW(NIONS), WMW(NCOMP), SMW(NPAIR)

        DATA  R/82.0567D-6/
        DATA  SMW/58.5,142.,85.0,132.,80.0,53.5,98.0,98.0,115.,63.0,   &
                  36.5,120.,247./   &
              IMW/ 1.0,23.0,18.0,35.5,96.0,97.0,63.0/,   &
              WMW/23.0,98.0,17.0,63.0,36.5/
!=====END MODULE OTH======================================================

!=====MODULE CGEN=========================================================

        CHARACTER VERSION*15
        DOUBLE PRECISION  GREAT, TINY, TINY2, ZERO, ONE
        DATA   &
           TINY/1D-20/, GREAT/1D10/, ZERO/0.0D0/, ONE/1.0D0/,   &
           TINY2/1D-11/
        DATA VERSION /'1.7 (03/26/07)'/

!=====END MODULE CGEN=====================================================

!=====MODULE SOLN=========================================================

      DOUBLE PRECISION EPS, MAXIT, NSWEEP, NDIV, ICLACT
!      DATA  R/82.0567D-6/, EPS/1D-6/, MAXIT/100/,
      DATA   EPS/1D-6/, MAXIT/100/,NSWEEP/4/,NDIV/5/

!=====END MODULE SOLN=====================================================

!=====module IONSdata=====================================================

!      INTEGER,private:: NPAIR
!      INTEGER,private::  NIONS
!      INTEGER,private::  NCOMP
      INTEGER,private::  NGASAQ
      INTEGER IACALC
!      PARAMETER (NPAIR=13,NIONS=7,NCOMP=5,NGASAQ=3)
      PARAMETER (NGASAQ=3)

      DOUBLE PRECISION MOLAL(NIONS), MOLALR(NPAIR), M0(NPAIR)
      REAL IONIC
      LOGICAL CALAOU, CALAIN, FRST, DRYF
      DOUBLE PRECISION GAMA(NPAIR)
      DOUBLE PRECISION ZZ(NPAIR)
      DOUBLE PRECISION Z(NIONS)
      DOUBLE PRECISION GAMOU(NPAIR)
      DOUBLE PRECISION GAMIN(NPAIR)
      DOUBLE PRECISION GASAQ(NGASAQ)
      DOUBLE PRECISION EPSACT
      DOUBLE PRECISION COH
      DOUBLE PRECISION CHNO3
      DOUBLE PRECISION CHCL
      DOUBLE PRECISION WATER
      DATA MOLAL/NIONS*0.0D0/, MOLALR/NPAIR*0.0D0/, GAMA/NPAIR*0.1D0/,   &
           GAMOU/NPAIR*1D10/,  GAMIN/NPAIR*1D10/,   CALAIN/.TRUE./,   &
           CALAOU/.TRUE./,     EPSACT/5D-2/    &  !,        ICLACT/0/,
           IACALC/1/   !,          WFTYP/2/
      DATA ZZ/1,2,1,2,1,1,2,1,1,1,1,1,2/, Z /1,1,1,1,2,1,1/
!      COMMON /IONS/ MOLAL(NIONS), MOLALR(NPAIR), GAMA(NPAIR), ZZ(NPAIR),
!     &              Z(NIONS),     GAMOU(NPAIR),  GAMIN(NPAIR),M0(NPAIR),
!     &              GASAQ(NGASAQ),
!     &              EPSACT,       COH,           CHNO3,       CHCL,
!     &              WATER,        IONIC,         IACALC,
!     &              FRST,         CALAIN,        CALAOU,      DRYF


!=====end module IONSdata=================================================

!=====MODULE ZSRdata======================================================

      INTEGER, PRIVATE :: NZSR
      PARAMETER ( NZSR=100)
      DOUBLE PRECISION AWAS(NZSR), AWSS(NZSR), AWAC(NZSR), AWSC(NZSR),   &
                    AWAN(NZSR), AWSN(NZSR), AWSB(NZSR), AWAB(NZSR),   &
                    AWSA(NZSR), AWLC(NZSR)

! awas= ammonium sulfate
      DATA AWAS/10*187.72,   &
       158.13,134.41,115.37,100.10, 87.86, 78.00, 70.00, 63.45, 58.02,   &
        53.46,   &
        49.59, 46.26, 43.37, 40.84, 38.59, 36.59, 34.79, 33.16, 31.67,   &
        30.31,   &
        29.07, 27.91, 26.84, 25.84, 24.91, 24.03, 23.21, 22.44, 21.70,   &
        21.01,   &
        20.34, 19.71, 19.11, 18.54, 17.99, 17.46, 16.95, 16.46, 15.99,   &
        15.54,   &
        15.10, 14.67, 14.26, 13.86, 13.47, 13.09, 12.72, 12.36, 12.01,   &
        11.67,   &
        11.33, 11.00, 10.68, 10.37, 10.06,  9.75,  9.45,  9.15,  8.86,   &
         8.57,   &
         8.29,  8.01,  7.73,  7.45,  7.18,  6.91,  6.64,  6.37,  6.10,   &
         5.83,   &
         5.56,  5.29,  5.02,  4.74,  4.47,  4.19,  3.91,  3.63,  3.34,   &
         3.05,   &
         2.75,  2.45,  2.14,  1.83,  1.51,  1.19,  0.87,  0.56,  0.26,   &
        0.1/
!
! awsn= sodium nitrate
!
      DATA AWSN/10*394.54,   &
       338.91,293.01,254.73,222.61,195.56,172.76,153.53,137.32,123.65,   &
       112.08,   &
       102.26, 93.88, 86.68, 80.45, 75.02, 70.24, 66.02, 62.26, 58.89,   &
        55.85,   &
        53.09, 50.57, 48.26, 46.14, 44.17, 42.35, 40.65, 39.06, 37.57,   &
        36.17,   &
        34.85, 33.60, 32.42, 31.29, 30.22, 29.20, 28.22, 27.28, 26.39,   &
        25.52,   &
        24.69, 23.89, 23.12, 22.37, 21.65, 20.94, 20.26, 19.60, 18.96,   &
        18.33,   &
        17.72, 17.12, 16.53, 15.96, 15.40, 14.85, 14.31, 13.78, 13.26,   &
        12.75,   &
        12.25, 11.75, 11.26, 10.77, 10.29,  9.82,  9.35,  8.88,  8.42,   &
         7.97,   &
         7.52,  7.07,  6.62,  6.18,  5.75,  5.32,  4.89,  4.47,  4.05,   &
         3.64,   &
         3.24,  2.84,  2.45,  2.07,  1.70,  1.34,  0.99,  0.65,  0.31,   &
        0.1/
!
! awsc= sodium chloride
!
      DATA AWSC/10*28.16,   &
        27.17, 26.27, 25.45, 24.69, 23.98, 23.33, 22.72, 22.14, 21.59,   &
        21.08,   &
        20.58, 20.12, 19.67, 19.24, 18.82, 18.43, 18.04, 17.67, 17.32,   &
        16.97,   &
        16.63, 16.31, 15.99, 15.68, 15.38, 15.08, 14.79, 14.51, 14.24,   &
        13.97,   &
        13.70, 13.44, 13.18, 12.93, 12.68, 12.44, 12.20, 11.96, 11.73,   &
        11.50,   &
        11.27, 11.05, 10.82, 10.60, 10.38, 10.16,  9.95,  9.74,  9.52,   &
         9.31,   &
         9.10,  8.89,  8.69,  8.48,  8.27,  8.07,  7.86,  7.65,  7.45,   &
         7.24,   &
         7.04,  6.83,  6.62,  6.42,  6.21,  6.00,  5.79,  5.58,  5.36,   &
         5.15,   &
         4.93,  4.71,  4.48,  4.26,  4.03,  3.80,  3.56,  3.32,  3.07,   &
         2.82,   &
         2.57,  2.30,  2.04,  1.76,  1.48,  1.20,  0.91,  0.61,  0.30,   &
        0.1/
!
! awac= ammonium chloride
!
      DATA AWAC/10*1209.00,   &
       1067.60,949.27,848.62,761.82,686.04,619.16,559.55,505.92,457.25,   &
       412.69,   &
       371.55,333.21,297.13,262.81,229.78,197.59,165.98,135.49,108.57,   &
        88.29,   &
        74.40, 64.75, 57.69, 52.25, 47.90, 44.30, 41.27, 38.65, 36.36,   &
        34.34,   &
        32.52, 30.88, 29.39, 28.02, 26.76, 25.60, 24.51, 23.50, 22.55,   &
        21.65,   &
        20.80, 20.00, 19.24, 18.52, 17.83, 17.17, 16.54, 15.93, 15.35,   &
        14.79,   &
        14.25, 13.73, 13.22, 12.73, 12.26, 11.80, 11.35, 10.92, 10.49,   &
        10.08,   &
         9.67,  9.28,  8.89,  8.51,  8.14,  7.77,  7.42,  7.06,  6.72,   &
         6.37,   &
         6.03,  5.70,  5.37,  5.05,  4.72,  4.40,  4.08,  3.77,  3.45,   &
         3.14,   &
         2.82,  2.51,  2.20,  1.89,  1.57,  1.26,  0.94,  0.62,  0.31,   &
        0.1/
!
! awss= sodium sulfate
!
      DATA AWSS/10*24.10,   &
        23.17, 22.34, 21.58, 20.90, 20.27, 19.69, 19.15, 18.64, 18.17,   &
        17.72,   &
        17.30, 16.90, 16.52, 16.16, 15.81, 15.48, 15.16, 14.85, 14.55,   &
        14.27,   &
        13.99, 13.73, 13.47, 13.21, 12.97, 12.73, 12.50, 12.27, 12.05,   &
        11.84,   &
        11.62, 11.42, 11.21, 11.01, 10.82, 10.63, 10.44, 10.25, 10.07,   &
         9.89,   &
         9.71,  9.53,  9.36,  9.19,  9.02,  8.85,  8.68,  8.51,  8.35,   &
         8.19,   &
         8.02,  7.86,  7.70,  7.54,  7.38,  7.22,  7.06,  6.90,  6.74,   &
         6.58,   &
         6.42,  6.26,  6.10,  5.94,  5.78,  5.61,  5.45,  5.28,  5.11,   &
         4.93,   &
         4.76,  4.58,  4.39,  4.20,  4.01,  3.81,  3.60,  3.39,  3.16,   &
         2.93,   &
         2.68,  2.41,  2.13,  1.83,  1.52,  1.19,  0.86,  0.54,  0.25,   &
        0.1/
!
! awab= ammonium bisulfate
!
      DATA AWAB/10*312.84,   &
       271.43,237.19,208.52,184.28,163.64,145.97,130.79,117.72,106.42,   &
        96.64,   &
        88.16, 80.77, 74.33, 68.67, 63.70, 59.30, 55.39, 51.89, 48.76,   &
        45.93,   &
        43.38, 41.05, 38.92, 36.97, 35.18, 33.52, 31.98, 30.55, 29.22,   &
        27.98,   &
        26.81, 25.71, 24.67, 23.70, 22.77, 21.90, 21.06, 20.27, 19.52,   &
        18.80,   &
        18.11, 17.45, 16.82, 16.21, 15.63, 15.07, 14.53, 14.01, 13.51,   &
        13.02,   &
        12.56, 12.10, 11.66, 11.24, 10.82, 10.42, 10.04,  9.66,  9.29,   &
         8.93,   &
         8.58,  8.24,  7.91,  7.58,  7.26,  6.95,  6.65,  6.35,  6.05,   &
         5.76,   &
         5.48,  5.20,  4.92,  4.64,  4.37,  4.09,  3.82,  3.54,  3.27,   &
         2.99,   &
         2.70,  2.42,  2.12,  1.83,  1.52,  1.22,  0.90,  0.59,  0.28,   &
        0.1/
!
! awsa= sulfuric acid
!
      DATA AWSA/34.00, 33.56, 29.22, 26.55, 24.61, 23.11, 21.89, 20.87,   &
        19.99, 18.45,   &
        17.83, 17.26, 16.73, 16.25, 15.80, 15.38, 14.98, 14.61, 14.26,   &
        13.93,   &
        13.61, 13.30, 13.01, 12.73, 12.47, 12.21, 11.96, 11.72, 11.49,   &
        11.26,   &
        11.04, 10.83, 10.62, 10.42, 10.23, 10.03,  9.85,  9.67,  9.49,   &
         9.31,   &
         9.14,  8.97,  8.81,  8.65,  8.49,  8.33,  8.18,  8.02,  7.87,   &
         7.73,   &
         7.58,  7.44,  7.29,  7.15,  7.01,  6.88,  6.74,  6.61,  6.47,   &
         6.34,   &
         6.21,  6.07,  5.94,  5.81,  5.68,  5.55,  5.43,  5.30,  5.17,   &
         5.04,   &
         4.91,  4.78,  4.65,  4.52,  4.39,  4.26,  4.13,  4.00,  3.86,   &
         3.73,   &
         3.59,  3.45,  3.31,  3.17,  3.02,  2.87,  2.71,  2.56,  2.39,   &
         2.22,   &
         2.05,  1.87,  1.68,  1.48,  1.27,  1.04,  0.80,  0.55,  0.28,   &
        0.1/
!
! awlc= (NH4)3H(SO4)2
!
      DATA AWLC/10*125.37,   &
       110.10, 97.50, 86.98, 78.08, 70.49, 63.97, 58.33, 53.43, 49.14,   &
        45.36,   &
        42.03, 39.07, 36.44, 34.08, 31.97, 30.06, 28.33, 26.76, 25.32,   &
        24.01,   &
        22.81, 21.70, 20.67, 19.71, 18.83, 18.00, 17.23, 16.50, 15.82,   &
        15.18,   &
        14.58, 14.01, 13.46, 12.95, 12.46, 11.99, 11.55, 11.13, 10.72,   &
        10.33,   &
         9.96,  9.60,  9.26,  8.93,  8.61,  8.30,  8.00,  7.72,  7.44,   &
         7.17,   &
         6.91,  6.66,  6.42,  6.19,  5.96,  5.74,  5.52,  5.31,  5.11,   &
         4.91,   &
         4.71,  4.53,  4.34,  4.16,  3.99,  3.81,  3.64,  3.48,  3.31,   &
         3.15,   &
         2.99,  2.84,  2.68,  2.53,  2.37,  2.22,  2.06,  1.91,  1.75,   &
         1.60,   &
         1.44,  1.28,  1.12,  0.95,  0.79,  0.62,  0.45,  0.29,  0.14,   &
        0.1/
!
! awan= ammonium nitrate
!
      DATA AWAN/10*960.19,   &
       853.15,763.85,688.20,623.27,566.92,517.54,473.91,435.06,400.26,   &
       368.89,   &
       340.48,314.63,291.01,269.36,249.46,231.11,214.17,198.50,184.00,   &
       170.58,   &
       158.15,146.66,136.04,126.25,117.24,108.97,101.39, 94.45, 88.11,   &
        82.33,   &
        77.06, 72.25, 67.85, 63.84, 60.16, 56.78, 53.68, 50.81, 48.17,   &
        45.71,   &
        43.43, 41.31, 39.32, 37.46, 35.71, 34.06, 32.50, 31.03, 29.63,   &
        28.30,   &
        27.03, 25.82, 24.67, 23.56, 22.49, 21.47, 20.48, 19.53, 18.61,   &
        17.72,   &
        16.86, 16.02, 15.20, 14.41, 13.64, 12.89, 12.15, 11.43, 10.73,   &
        10.05,   &
         9.38,  8.73,  8.09,  7.47,  6.86,  6.27,  5.70,  5.15,  4.61,   &
         4.09,   &
         3.60,  3.12,  2.66,  2.23,  1.81,  1.41,  1.03,  0.67,  0.32,   &
        0.1/
!
! awsb= sodium bisulfate
!
      DATA AWSB/10*55.99,   &
        53.79, 51.81, 49.99, 48.31, 46.75, 45.28, 43.91, 42.62, 41.39,   &
        40.22,   &
        39.10, 38.02, 36.99, 36.00, 35.04, 34.11, 33.21, 32.34, 31.49,   &
        30.65,   &
        29.84, 29.04, 28.27, 27.50, 26.75, 26.01, 25.29, 24.57, 23.87,   &
        23.17,   &
        22.49, 21.81, 21.15, 20.49, 19.84, 19.21, 18.58, 17.97, 17.37,   &
        16.77,   &
        16.19, 15.63, 15.08, 14.54, 14.01, 13.51, 13.01, 12.53, 12.07,   &
        11.62,   &
        11.19, 10.77, 10.36,  9.97,  9.59,  9.23,  8.87,  8.53,  8.20,   &
         7.88,   &
         7.57,  7.27,  6.97,  6.69,  6.41,  6.14,  5.88,  5.62,  5.36,   &
         5.11,   &
         4.87,  4.63,  4.39,  4.15,  3.92,  3.68,  3.45,  3.21,  2.98,   &
         2.74,   &
         2.49,  2.24,  1.98,  1.72,  1.44,  1.16,  0.87,  0.57,  0.28,   &
        0.1/
!
! *** ZSR RELATIONSHIP PARAMETERS **************************************

!=====END MODULE ZSRdata==================================================

!=====MODULE SALT=========================================================

      DOUBLE PRECISION CH2SO4
      DOUBLE PRECISION CNH42S4
      DOUBLE PRECISION CNH4HS4
      DOUBLE PRECISION CNACL
      DOUBLE PRECISION CNA2SO4
      DOUBLE PRECISION CNANO3
      DOUBLE PRECISION CNH4NO3
      DOUBLE PRECISION CNH4CL
      DOUBLE PRECISION CNAHSO4
      DOUBLE PRECISION CLC

!      COMMON /SALT/ CH2SO4,  CNH42S4, CNH4HS4, CNACL,   CNA2SO4,
!     &              CNANO3,  CNH4NO3, CNH4CL,  CNAHSO4, CLC

!=====END MODULE SALT=====================================================

!=====MODULE GAS==========================================================

      DOUBLE PRECISION GNH3
      DOUBLE PRECISION GHNO3
      DOUBLE PRECISION GHCL

!=====END MODULE GA=======================================================

!=====MODULE EQUK=========================================================

      DOUBLE PRECISION XK1
      DOUBLE PRECISION XK2
      DOUBLE PRECISION XK3
      DOUBLE PRECISION XK4
      DOUBLE PRECISION XK5
      DOUBLE PRECISION XK6
      DOUBLE PRECISION XK7
      DOUBLE PRECISION XK8
      DOUBLE PRECISION XK9
      DOUBLE PRECISION XK10
      DOUBLE PRECISION XK11
      DOUBLE PRECISION XK12
      DOUBLE PRECISION XK13
      DOUBLE PRECISION XK14
      DOUBLE PRECISION XKW
      DOUBLE PRECISION XK21
      DOUBLE PRECISION XK22
      DOUBLE PRECISION XK31
      DOUBLE PRECISION XK32
      DOUBLE PRECISION XK41
      DOUBLE PRECISION XK42

!=====END MODULE EQUK=====================================================

      END MODULE module_data_isrpia_data
